/*
 * Decompiled with CFR 0.152.
 */
package oreregistry.util;

import java.util.List;
import net.minecraft.item.ItemStack;
import oreregistry.OreRegistry;
import oreregistry.api.IUnificationHandler;
import oreregistry.api.OreRegistryApi;
import oreregistry.api.info.IProductInfo;
import oreregistry.api.registry.IProduct;
import oreregistry.api.registry.IResource;
import oreregistry.util.Product;

public class ProductUtils {
    public static void chooseProduct(Product product, int variantIndex) {
        List<ItemStack> variants = product.getVariants();
        if (variantIndex >= variants.size()) {
            variantIndex = variants.size();
        }
        for (int i = 0; i < variants.size(); ++i) {
            ItemStack variant = variants.get(i);
            if (i == variantIndex) {
                product.choseProduct(variant, variantIndex);
                continue;
            }
            OreRegistry.unusedItems.add(variant.func_77946_l());
        }
    }

    public static ItemStack tryUnifyItem(ItemStack oldStack) {
        IProductInfo productInfo = OreRegistryApi.info.getProductInfo(oldStack);
        if (productInfo != null) {
            IResource resource = OreRegistry.registry.getResource(productInfo.getResourceType());
            if (resource == null) {
                return ItemStack.field_190927_a;
            }
            IProduct product = resource.getProduct(productInfo.getProductType());
            if (product == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack newStack = product.getChosenProduct();
            if (ProductUtils.needUnification(oldStack, newStack)) {
                return ItemStack.field_190927_a;
            }
            newStack.func_190920_e(oldStack.func_190916_E());
            for (IUnificationHandler handler : OreRegistryApi.registry.getUnificationHandlers(resource.getType())) {
                handler.onUnifyItem(oldStack, newStack, product);
            }
            return newStack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean needUnification(ItemStack oldStack, ItemStack newStack) {
        return ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack) && ItemStack.func_77970_a((ItemStack)oldStack, (ItemStack)newStack);
    }
}

