/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.mail.tiles.TileTrader;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketTraderAddressResponse
extends PacketCoordinates
implements IForestryPacketClient {
    private String addressName;

    public PacketTraderAddressResponse() {
    }

    public PacketTraderAddressResponse(TileTrader tile, String addressName) {
        super(tile);
        this.addressName = addressName;
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.TRADING_ADDRESS_RESPONSE;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeUTF(this.addressName);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.addressName = data.readUTF();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tile = this.getTarget(player.worldObj);
        if (tile instanceof TileTrader) {
            ((TileTrader)tile).handleSetAddressResponse(this.addressName);
        }
    }
}

