/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.mail.POBoxInfo;
import forestry.mail.gui.GuiMailboxInfo;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;

public class PacketPOBoxInfoResponse
extends ForestryPacket
implements IForestryPacketClient {
    public POBoxInfo poboxInfo;

    public PacketPOBoxInfoResponse() {
    }

    public PacketPOBoxInfoResponse(POBoxInfo info) {
        this.poboxInfo = info;
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.POBOX_INFO_RESPONSE;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        if (this.poboxInfo == null) {
            data.writeShort(-1);
            return;
        }
        data.writeShort(0);
        data.writeInt(this.poboxInfo.playerLetters);
        data.writeInt(this.poboxInfo.tradeLetters);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        short isNotNull = data.readShort();
        if (isNotNull < 0) {
            return;
        }
        this.poboxInfo = new POBoxInfo(data.readInt(), data.readInt());
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        GuiMailboxInfo.instance.setPOBoxInfo(this.poboxInfo);
    }
}

