/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.AIButterflyBase;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.entities.EnumButterflyState;
import net.minecraft.util.ChunkCoordinates;

public abstract class AIButterflyInteract
extends AIButterflyBase {
    protected ChunkCoordinates rest;
    private boolean canInteract = false;
    private boolean hasInteracted = false;

    protected AIButterflyInteract(EntityButterfly entity) {
        super(entity);
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        if (this.entity.getState() != EnumButterflyState.RESTING) {
            return false;
        }
        this.rest = new ChunkCoordinates((int)this.entity.posX, (int)Math.floor(this.entity.posY) - 1, (int)this.entity.posZ);
        if (this.entity.worldObj.isAirBlock(this.rest.posX, this.rest.posY, this.rest.posZ)) {
            return false;
        }
        this.canInteract = this.canInteract();
        return this.canInteract;
    }

    protected abstract boolean canInteract();

    public boolean continueExecuting() {
        return this.canInteract && !this.hasInteracted;
    }

    public void startExecuting() {
    }

    public void resetTask() {
        this.canInteract = false;
        this.hasInteracted = false;
        this.rest = null;
    }

    protected void setHasInteracted() {
        this.hasInteracted = true;
    }
}

