/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.tiles;

import forestry.api.farming.DefaultFarmListener;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.api.multiblock.IFarmComponent;
import forestry.core.utils.vect.Vect;
import forestry.farming.tiles.TileFarm;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileFarmControl
extends TileFarm
implements IFarmComponent.Listener {
    private final IFarmListener farmListener = new ControlFarmListener(this);

    @Override
    public IFarmListener getFarmListener() {
        return this.farmListener;
    }

    private static class ControlFarmListener
    extends DefaultFarmListener {
        private final TileFarmControl tile;

        public ControlFarmListener(TileFarmControl tile) {
            this.tile = tile;
        }

        @Override
        public boolean cancelTask(IFarmLogic logic, FarmDirection direction) {
            return this.hasRedstoneSignal(direction.getForgeDirection()) || this.hasRedstoneSignal(ForgeDirection.UP) || this.hasRedstoneSignal(ForgeDirection.DOWN);
        }

        private boolean hasRedstoneSignal(ForgeDirection direction) {
            Vect side = new Vect(this.tile).add(direction);
            int dir = direction.getOpposite().ordinal();
            World world = this.tile.getWorldObj();
            return world.getIndirectPowerLevelTo(side.x, side.y, side.z, dir) > 0 || world.isBlockProvidingPowerTo(side.x, side.y, side.z, dir) > 0;
        }
    }
}

