/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import cpw.mods.fml.common.eventhandler.Event;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.gui.ContainerWorktable;
import forestry.factory.gui.GuiWorktable;
import forestry.factory.inventory.InventoryCraftingForestry;
import forestry.factory.inventory.InventoryGhostCrafting;
import forestry.factory.inventory.InventoryWorktable;
import forestry.factory.recipes.MemorizedRecipe;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.ICrafterWorktable;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class TileWorktable
extends TileBase
implements ICrafterWorktable {
    private final RecipeMemory recipeMemory;
    private final InventoryAdapterTile craftingDisplay;
    private MemorizedRecipe currentRecipe;

    public TileWorktable() {
        super("worktable");
        this.setInternalInventory(new InventoryWorktable(this));
        this.craftingDisplay = new InventoryGhostCrafting<TileWorktable>(this, 10);
        this.recipeMemory = new RecipeMemory();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.craftingDisplay.writeToNBT(nbttagcompound);
        this.recipeMemory.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.craftingDisplay.readFromNBT(nbttagcompound);
        this.recipeMemory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.craftingDisplay.writeData(data);
        this.recipeMemory.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.craftingDisplay.readData(data);
        this.recipeMemory.readData(data);
    }

    @Override
    public void validate() {
        super.validate();
        this.recipeMemory.validate(this.worldObj);
    }

    public boolean hasRecipeConflict() {
        return this.currentRecipe != null && this.currentRecipe.hasRecipeConflict();
    }

    public void chooseNextConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.incrementRecipe();
        }
    }

    public void choosePreviousConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.decrementRecipe();
        }
    }

    @Override
    public boolean canTakeStack(int craftingSlotIndex) {
        if (craftingSlotIndex == 9) {
            return this.canCraftCurrentRecipe();
        }
        return true;
    }

    private boolean canCraftCurrentRecipe() {
        ItemStack[] inventory;
        if (this.currentRecipe == null) {
            return false;
        }
        ItemStack[] recipeItems = InventoryUtil.getStacks((IInventory)this.currentRecipe.getCraftMatrix());
        InventoryCraftingForestry crafting = RecipeUtil.getCraftRecipe(recipeItems, inventory = InventoryUtil.getStacks((IInventory)this), this.worldObj, this.currentRecipe.getRecipeOutput());
        return crafting != null;
    }

    @Override
    public boolean onCraftingStart(EntityPlayer player) {
        ItemStack[] inventory;
        if (this.currentRecipe == null) {
            return false;
        }
        ItemStack[] recipeItems = InventoryUtil.getStacks((IInventory)this.currentRecipe.getCraftMatrix());
        InventoryCraftingForestry crafting = RecipeUtil.getCraftRecipe(recipeItems, inventory = InventoryUtil.getStacks((IInventory)this), this.worldObj, this.currentRecipe.getRecipeOutput());
        if (crafting == null) {
            return false;
        }
        recipeItems = InventoryUtil.getStacks((IInventory)crafting);
        ItemStack[] removed = InventoryUtil.removeSets((IInventory)this, 1, recipeItems, player, false, false, false);
        if (removed == null) {
            return false;
        }
        this.setCraftingDisplay((IInventory)crafting);
        return true;
    }

    @Override
    public void onCraftingComplete(EntityPlayer player) {
        IInventory craftingInventory = this.getCraftingDisplay();
        for (int i = 0; i < craftingInventory.getSizeInventory(); ++i) {
            ItemStack itemStack = craftingInventory.getStackInSlot(i);
            if (itemStack == null) continue;
            ItemStack container = null;
            if (itemStack.getItem().hasContainerItem(itemStack)) {
                container = itemStack.getItem().getContainerItem(itemStack);
            } else if (itemStack.stackSize > 1) {
                container = ItemStackUtil.createSplitStack(itemStack, itemStack.stackSize - 1);
                itemStack.stackSize = 1;
            }
            if (container == null) continue;
            if (container != null && container.isItemStackDamageable() && container.getItemDamage() > container.getMaxDamage()) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, container));
                continue;
            }
            if (InventoryUtil.tryAddStack((IInventory)this, container, true)) continue;
            player.dropPlayerItemWithRandomChoice(container, false);
        }
        if (!this.worldObj.isRemote) {
            this.recipeMemory.memorizeRecipe(this.worldObj.getTotalWorldTime(), this.currentRecipe);
        }
    }

    @Override
    public ItemStack getResult() {
        if (this.currentRecipe == null) {
            return null;
        }
        ItemStack result = this.currentRecipe.getRecipeOutput();
        if (result != null) {
            result = result.copy();
        }
        return result;
    }

    public RecipeMemory getMemory() {
        return this.recipeMemory;
    }

    public void chooseRecipeMemory(int recipeIndex) {
        MemorizedRecipe recipe = this.recipeMemory.getRecipe(recipeIndex);
        this.setCurrentRecipe(recipe);
    }

    private void setCraftingDisplay(IInventory craftMatrix) {
        if (craftMatrix == null) {
            return;
        }
        for (int slot = 0; slot < craftMatrix.getSizeInventory(); ++slot) {
            this.craftingDisplay.setInventorySlotContents(slot, craftMatrix.getStackInSlot(slot));
        }
    }

    public IInventory getCraftingDisplay() {
        return new InventoryMapper((IInventory)this.craftingDisplay, 0, 9);
    }

    public void clearCraftMatrix() {
        for (int slot = 0; slot < this.craftingDisplay.getSizeInventory(); ++slot) {
            this.craftingDisplay.setInventorySlotContents(slot, null);
        }
    }

    public void setCurrentRecipe(InventoryCraftingForestry crafting) {
        ItemStack[] currentStacks;
        ItemStack[] stacks;
        MemorizedRecipe recipe;
        List<ItemStack> recipeOutputs = RecipeUtil.findMatchingRecipes(crafting, this.worldObj);
        MemorizedRecipe memorizedRecipe = recipe = recipeOutputs.size() == 0 ? null : new MemorizedRecipe(crafting, recipeOutputs);
        if (this.currentRecipe != null && recipe != null && recipe.hasRecipeOutput(this.currentRecipe.getRecipeOutput()) && ItemStackUtil.equalSets(stacks = InventoryUtil.getStacks((IInventory)crafting), currentStacks = InventoryUtil.getStacks((IInventory)this.currentRecipe.getCraftMatrix()))) {
            return;
        }
        this.setCurrentRecipe(recipe);
    }

    public MemorizedRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipe(MemorizedRecipe recipe) {
        this.currentRecipe = recipe;
        if (this.currentRecipe != null) {
            this.setCraftingDisplay((IInventory)this.currentRecipe.getCraftMatrix());
        }
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiWorktable(player, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerWorktable(player, this);
    }
}

