/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.blocks;

import forestry.core.blocks.IMachinePropertiesTESR;
import forestry.core.render.IBlockRenderer;
import forestry.core.tiles.TileForestry;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.energy.tiles.TileEngineClockwork;
import forestry.energy.tiles.TileEngineElectric;
import forestry.energy.tiles.TileEnginePeat;
import forestry.energy.tiles.TileGenerator;
import forestry.plugins.PluginEnergy;

public enum BlockEngineType implements IMachinePropertiesTESR
{
    ELECTRIC(TileEngineElectric.class, "EngineTin", "/engine_tin_"),
    PEAT(TileEnginePeat.class, "EngineCopper", "/engine_copper_"),
    BIOGAS(TileEngineBiogas.class, "EngineBronze", "/engine_bronze_"),
    GENERATOR(TileGenerator.class, "Generator", "/generator_"),
    CLOCKWORK(TileEngineClockwork.class, "EngineClockwork", "/engine_clock_");

    public static final BlockEngineType[] VALUES;
    private final String teIdent;
    private final Class<? extends TileForestry> teClass;
    private final IBlockRenderer renderer;

    private BlockEngineType(Class<? extends TileForestry> teClass, String teName, String textureName) {
        this.teIdent = "forestry." + teName;
        this.teClass = teClass;
        this.renderer = PluginEnergy.proxy.getRenderDefaultEngine("textures/blocks" + textureName);
    }

    @Override
    public int getMeta() {
        return this.ordinal();
    }

    @Override
    public String getTeIdent() {
        return this.teIdent;
    }

    @Override
    public Class<? extends TileForestry> getTeClass() {
        return this.teClass;
    }

    @Override
    public IBlockRenderer getRenderer() {
        return this.renderer;
    }

    static {
        VALUES = BlockEngineType.values();
    }
}

