/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.core.gui.ContainerEscritoire;
import forestry.core.gui.GuiEscritoire;
import forestry.core.inventory.InventoryEscritoire;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEscritoire
extends TileBase
implements ISidedInventory,
ISlotPickupWatcher,
IStreamableGui {
    private final EscritoireGame game = new EscritoireGame();

    public TileEscritoire() {
        super("escritoire");
        this.setInternalInventory(new InventoryEscritoire(this));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.game.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.game.writeToNBT(nbttagcompound);
    }

    public EscritoireGame getGame() {
        return this.game;
    }

    public void choose(GameProfile gameProfile, int index) {
        this.game.choose(index);
        this.processTurnResult(gameProfile);
    }

    private void processTurnResult(GameProfile gameProfile) {
        if (this.getGame().getStatus() != EscritoireGame.Status.SUCCESS) {
            return;
        }
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(this.getStackInSlot(0));
        if (individual == null) {
            return;
        }
        IAlleleSpecies species = individual.getGenome().getPrimary();
        for (ItemStack itemstack : species.getResearchBounty(this.worldObj, gameProfile, individual, this.game.getBountyLevel())) {
            InventoryUtil.addStack((IInventory)this.getInternalInventory(), itemstack, 1, 6, true);
        }
    }

    private boolean areProbeSlotsFilled() {
        int filledSlots = 0;
        int required = this.game.getSampleSize(5);
        for (int i = 7; i < 7 + required; ++i) {
            if (this.getStackInSlot(i) == null) continue;
            ++filledSlots;
        }
        return filledSlots >= required;
    }

    public void probe() {
        if (this.worldObj.isRemote) {
            return;
        }
        ItemStack analyze = this.getStackInSlot(0);
        if (analyze != null && this.areProbeSlotsFilled()) {
            this.game.probe(analyze, (IInventory)this, 7, 5);
        }
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.game.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.game.readData(data);
    }

    @Override
    public void onPickupFromSlot(int slotIndex, EntityPlayer player) {
        if (slotIndex == 0) {
            this.game.reset();
        }
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiEscritoire(player, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerEscritoire(player, this);
    }
}

