/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import cpw.mods.fml.common.FMLCommonHandler;
import forestry.core.TickHandlerCoreClient;
import forestry.core.multiblock.MultiblockClientTickHandler;
import forestry.core.proxy.ProxyCommon;
import forestry.core.worldgen.WorldGenerator;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ProxyCommonClient
extends ProxyCommon {
    @Override
    public void registerTickHandlers(WorldGenerator worldGenerator) {
        super.registerTickHandlers(worldGenerator);
        FMLCommonHandler.instance().bus().register((Object)new TickHandlerCoreClient());
        FMLCommonHandler.instance().bus().register((Object)new MultiblockClientTickHandler());
    }

    @Override
    public File getForestryRoot() {
        return Minecraft.getMinecraft().mcDataDir;
    }

    @Override
    public World getRenderWorld() {
        return this.getClientInstance().theWorld;
    }

    @Override
    public boolean isOp(EntityPlayer player) {
        return false;
    }

    @Override
    public double getBlockReachDistance(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityPlayerSP) {
            return this.getClientInstance().playerController.getBlockReachDistance();
        }
        return 4.0;
    }

    @Override
    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    public String getDisplayName(ItemStack itemstack) {
        return itemstack.getItem().getItemStackDisplayName(itemstack);
    }

    @Override
    public void playSoundFX(World world, int x, int y, int z, Block block) {
        if (!world.isRemote) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.stepSound.getStepResourcePath(), block.stepSound.getVolume(), block.stepSound.getPitch());
        }
    }

    @Override
    public void playBlockBreakSoundFX(World world, int x, int y, int z, Block block) {
        if (!world.isRemote) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.stepSound.getBreakSound(), block.stepSound.getVolume() / 4.0f, block.stepSound.getPitch());
        }
    }

    @Override
    public void playBlockPlaceSoundFX(World world, int x, int y, int z, Block block) {
        if (!world.isRemote) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.stepSound.getStepResourcePath(), block.stepSound.getVolume() / 4.0f, block.stepSound.getPitch());
        }
    }

    @Override
    public void playSoundFX(World world, int x, int y, int z, String sound, float volume, float pitch) {
        world.playSound((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sound, volume, (1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.2f) * 0.7f, false);
    }

    @Override
    public void addBlockDestroyEffects(World world, int xCoord, int yCoord, int zCoord, Block block, int i) {
        if (world.isRemote) {
            this.getClientInstance().effectRenderer.addBlockDestroyEffects(xCoord, yCoord, zCoord, block, i);
        } else {
            super.addBlockDestroyEffects(world, xCoord, yCoord, zCoord, block, i);
        }
    }

    @Override
    public void addBlockPlaceEffects(World world, int xCoord, int yCoord, int zCoord, Block block, int i) {
        if (world.isRemote) {
            this.playBlockPlaceSoundFX(world, xCoord, yCoord, zCoord, block);
        } else {
            super.addBlockPlaceEffects(world, xCoord, yCoord, zCoord, block, i);
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.getMinecraft().thePlayer;
    }
}

