/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.mojang.authlib.GameProfile;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.api.multiblock.MultiblockTileEntityBase;
import forestry.core.config.Constants;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.IGuiHandlerTile;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.ILocatable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.World;

public abstract class MultiblockTileEntityForestry<T extends IMultiblockLogic>
extends MultiblockTileEntityBase<T>
implements ISidedInventory,
IFilterSlotDelegate,
ILocatable,
IGuiHandlerTile {
    private GameProfile owner;

    public MultiblockTileEntityForestry(T multiblockLogic) {
        super(multiblockLogic);
    }

    public void openGui(EntityPlayer player) {
        GuiHandler.openGui(player, this);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.hasKey("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)data.getCompoundTag("owner"));
        }
        this.getInternalInventory().readFromNBT(data);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            data.setTag("owner", (NBTBase)nbt);
        }
        this.getInternalInventory().writeToNBT(data);
    }

    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.instance();
    }

    public boolean allowsAutomation() {
        return false;
    }

    public final int getSizeInventory() {
        return this.getInternalInventory().getSizeInventory();
    }

    public final ItemStack getStackInSlot(int slotIndex) {
        return this.getInternalInventory().getStackInSlot(slotIndex);
    }

    public final ItemStack decrStackSize(int slotIndex, int amount) {
        return this.getInternalInventory().decrStackSize(slotIndex, amount);
    }

    public final ItemStack getStackInSlotOnClosing(int slotIndex) {
        return this.getInternalInventory().getStackInSlotOnClosing(slotIndex);
    }

    public final void setInventorySlotContents(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().setInventorySlotContents(slotIndex, itemstack);
    }

    public final int getInventoryStackLimit() {
        return this.getInternalInventory().getInventoryStackLimit();
    }

    public final void openInventory() {
        this.getInternalInventory().openInventory();
    }

    public final void closeInventory() {
        this.getInternalInventory().closeInventory();
    }

    public final String getInventoryName() {
        return this.getInternalInventory().getInventoryName();
    }

    public final boolean isUseableByPlayer(EntityPlayer player) {
        return this.getInternalInventory().isUseableByPlayer(player);
    }

    public final boolean hasCustomInventoryName() {
        return this.getInternalInventory().hasCustomInventoryName();
    }

    public final boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().isItemValidForSlot(slotIndex, itemStack);
    }

    public final int[] getAccessibleSlotsFromSide(int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().getAccessibleSlotsFromSide(side);
        }
        return Constants.SLOTS_NONE;
    }

    public final boolean canInsertItem(int slotIndex, ItemStack itemStack, int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().canInsertItem(slotIndex, itemStack, side);
        }
        return false;
    }

    public final boolean canExtractItem(int slotIndex, ItemStack itemStack, int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().canExtractItem(slotIndex, itemStack, side);
        }
        return false;
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public final boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    @Override
    public final World getWorld() {
        return this.worldObj;
    }

    @Override
    public final GameProfile getOwner() {
        return this.owner;
    }

    public final void setOwner(GameProfile owner) {
        this.owner = owner;
    }
}

