/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotFilteredInventory;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.TileNaturalistChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;

public class ContainerNaturalistInventory
extends ContainerTile<TileNaturalistChest>
implements IGuiSelectable {
    public ContainerNaturalistInventory(InventoryPlayer player, TileNaturalistChest tile, int page) {
        super(tile, player, 18, 120);
        ContainerNaturalistInventory.addInventory(this, tile, page);
    }

    public static <T extends IInventory & IFilterSlotDelegate> void addInventory(ContainerForestry container, T inventory, int selectedPage) {
        for (int page = 0; page < 5; ++page) {
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 5; ++y) {
                    int slot = y + page * 25 + x * 5;
                    if (page == selectedPage) {
                        container.addSlotToContainer(new SlotFilteredInventory(inventory, slot, 100 + y * 18, 21 + x * 18));
                        continue;
                    }
                    container.addSlotToContainer(new SlotFilteredInventory(inventory, slot, -10000, -10000));
                }
            }
        }
    }

    @Override
    public void handleSelectionRequest(EntityPlayerMP player, PacketGuiSelectRequest packet) {
        ((TileNaturalistChest)this.tile).flipPage((EntityPlayer)player, (short)packet.getPrimaryIndex());
    }

    public void addCraftingToCrafters(ICrafting p_75132_1_) {
        super.addCraftingToCrafters(p_75132_1_);
        ((TileNaturalistChest)this.tile).increaseNumPlayersUsing();
    }

    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        ((TileNaturalistChest)this.tile).decreaseNumPlayersUsing();
    }
}

