/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Individual
implements IIndividual {
    protected boolean isAnalyzed = false;

    @Override
    public boolean isAnalyzed() {
        return this.isAnalyzed;
    }

    @Override
    public boolean analyze() {
        if (this.isAnalyzed) {
            return false;
        }
        this.isAnalyzed = true;
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound == null) {
            return;
        }
        this.isAnalyzed = nbttagcompound.getBoolean("IsAnalyzed");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setBoolean("IsAnalyzed", this.isAnalyzed);
    }

    @Override
    public String getIdent() {
        return this.getGenome().getPrimary().getUID();
    }

    @Override
    public String getDisplayName() {
        return this.getGenome().getPrimary().getName();
    }

    @Override
    public boolean hasEffect() {
        return this.getGenome().getPrimary().hasEffect();
    }

    @Override
    public boolean isSecret() {
        return this.getGenome().getPrimary().isSecret();
    }

    @Override
    public boolean isGeneticEqual(IIndividual other) {
        return this.getGenome().isGeneticEqual(other.getGenome());
    }

    @Override
    public boolean isPureBred(IChromosomeType chromosomeType) {
        return this.getGenome().getActiveAllele(chromosomeType).getUID().equals(this.getGenome().getInactiveAllele(chromosomeType).getUID());
    }
}

