/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids.tanks;

import forestry.core.fluids.FakeTankUpdateHandler;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.ITankUpdateHandler;
import forestry.core.fluids.TankManager;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.tooltips.ToolTipLine;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumRarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class StandardTank
extends FluidTank
implements IStreamable {
    public TankMode tankMode = TankMode.DEFAULT;
    private static final int DEFAULT_COLOR = 0xFFFFFF;
    @Nonnull
    private ITankUpdateHandler tankUpdateHandler = FakeTankUpdateHandler.instance;
    private int tankIndex;
    protected final ToolTip toolTip = new ToolTip(){

        @Override
        public void refresh() {
            StandardTank.this.refreshTooltip();
        }
    };

    public StandardTank(int capacity) {
        super(capacity);
    }

    public StandardTank(FluidStack fluid, int capacity) {
        this(capacity);
        this.setFluid(fluid);
    }

    public StandardTank(int capacity, TileEntity tile) {
        this(capacity);
        this.tile = tile;
    }

    public StandardTank(FluidStack fluid, int capacity, TileEntity tile) {
        this(capacity);
        this.tile = tile;
        this.setFluid(fluid);
    }

    public void setTankIndex(int index) {
        this.tankIndex = index;
    }

    public void setTankUpdateHandler(@Nonnull TankManager tankUpdateHandler) {
        this.tankUpdateHandler = tankUpdateHandler;
    }

    public int getTankIndex() {
        return this.tankIndex;
    }

    public int getColor() {
        Fluid f = this.getFluidType();
        if (f == null) {
            return 0xFFFFFF;
        }
        return f.getColor(this.getFluid());
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().amount <= 0;
    }

    public boolean isFull() {
        return this.getFluid() != null && this.getFluid().amount == this.getCapacity();
    }

    public int getRemainingSpace() {
        return this.capacity - this.getFluidAmount();
    }

    public Fluid getFluidType() {
        return this.getFluid() != null ? this.getFluid().getFluid() : null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.amount <= 0) {
            return 0;
        }
        if (!this.accepts(resource.getFluid())) {
            return 0;
        }
        int filled = super.fill(resource, doFill);
        if (doFill && filled > 0) {
            this.tankUpdateHandler.updateTankLevels(this);
        }
        return filled;
    }

    public boolean accepts(Fluid fluid) {
        return fluid != null;
    }

    public boolean canBeFilledExternally() {
        switch (this.tankMode) {
            case DEFAULT: 
            case INPUT: {
                return true;
            }
        }
        return false;
    }

    public boolean canBeDrainedExternally() {
        switch (this.tankMode) {
            case DEFAULT: 
            case OUTPUT: {
                return true;
            }
        }
        return false;
    }

    public boolean canFill(Fluid fluid, int amount) {
        if (fluid == null) {
            return false;
        }
        FluidStack fluidStack = new FluidStack(fluid, amount);
        return this.canFill(fluidStack);
    }

    public boolean canFill(FluidStack fluidStack) {
        return this.fill(fluidStack, false) == fluidStack.amount;
    }

    public boolean canDrain(int amount) {
        FluidStack drained = this.drain(amount, false);
        return drained != null && drained.amount == amount;
    }

    public boolean canDrain(FluidStack toDrain) {
        FluidStack drained = this.drain(toDrain.amount, false);
        return FluidHelper.areFluidStacksEqual(drained, toDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        FluidStack drained = super.drain(maxDrain, doDrain);
        if (doDrain && drained != null && drained.amount > 0) {
            this.tankUpdateHandler.updateTankLevels(this);
        }
        return drained;
    }

    public String toString() {
        return String.format("Tank: %s, %d/%d", this.fluid != null && this.fluid.getFluid() != null ? this.fluid.getFluid().getName() : "Empty", this.getFluidAmount(), this.getCapacity());
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }

    protected boolean hasFluid() {
        FluidStack fluid = this.getFluid();
        return fluid != null && fluid.amount > 0 && fluid.getFluid() != null;
    }

    protected void refreshTooltip() {
        this.toolTip.clear();
        int amount = 0;
        if (this.hasFluid()) {
            Fluid fluidType = this.getFluidType();
            EnumRarity rarity = fluidType.getRarity();
            if (rarity == null) {
                rarity = EnumRarity.common;
            }
            ToolTipLine fluidName = new ToolTipLine(fluidType.getLocalizedName(this.getFluid()), rarity.rarityColor, 2);
            this.toolTip.add(fluidName);
            amount = this.getFluid().amount;
        }
        this.toolTip.add(new ToolTipLine(String.format(Locale.ENGLISH, "%,d / %,d", amount, this.getCapacity())));
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeFluidStack(this.fluid);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.fluid = data.readFluidStack();
    }

    public static enum TankMode {
        DEFAULT,
        OUTPUT,
        INPUT,
        INTERNAL;

    }
}

