/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.entities;

import forestry.core.entities.EntityMinecartForestry;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.utils.InventoryUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class EntityMinecartContainerForestry
extends EntityMinecartForestry
implements ISidedInventory,
IFilterSlotDelegate {
    private boolean dropContentsWhenDead = true;

    public EntityMinecartContainerForestry(World world) {
        super(world);
    }

    public EntityMinecartContainerForestry(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound nbtTagCompound) {
        super.readEntityFromNBT(nbtTagCompound);
        this.getInternalInventory().readFromNBT(nbtTagCompound);
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound nbtTagCompound) {
        super.writeEntityToNBT(nbtTagCompound);
        this.getInternalInventory().writeToNBT(nbtTagCompound);
    }

    public void setDead() {
        if (this.dropContentsWhenDead && !this.worldObj.isRemote) {
            InventoryUtil.dropInventory((IInventory)this.getInternalInventory(), this.worldObj, this.posX, this.posY, this.posZ);
        }
        super.setDead();
    }

    protected void applyDrag() {
        int redstoneLevel = 15 - Container.calcRedstoneFromInventory((IInventory)this);
        double drag = 0.98f + (float)redstoneLevel * 0.001f;
        this.motionX *= drag;
        this.motionY *= 0.0;
        this.motionZ *= drag;
    }

    public void travelToDimension(int dimensionId) {
        this.dropContentsWhenDead = false;
        super.travelToDimension(dimensionId);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return !this.isDead && player.getDistanceSqToEntity((Entity)this) <= 64.0;
    }

    public int getSizeInventory() {
        return this.getInternalInventory().getSizeInventory();
    }

    public final ItemStack getStackInSlot(int slotIndex) {
        return this.getInternalInventory().getStackInSlot(slotIndex);
    }

    public ItemStack decrStackSize(int slotIndex, int amount) {
        return this.getInternalInventory().decrStackSize(slotIndex, amount);
    }

    public final ItemStack getStackInSlotOnClosing(int slotIndex) {
        return this.getInternalInventory().getStackInSlotOnClosing(slotIndex);
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().setInventorySlotContents(slotIndex, itemstack);
    }

    public final int getInventoryStackLimit() {
        return this.getInternalInventory().getInventoryStackLimit();
    }

    public final void openInventory() {
        this.getInternalInventory().openInventory();
    }

    public final void closeInventory() {
        this.getInternalInventory().closeInventory();
    }

    public final String getInventoryName() {
        return this.getInternalInventory().getInventoryName();
    }

    public final boolean hasCustomInventoryName() {
        return false;
    }

    public final boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().isItemValidForSlot(slotIndex, itemStack);
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return this.getInternalInventory().getAccessibleSlotsFromSide(side);
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.getInternalInventory().canInsertItem(slot, stack, side);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return this.getInternalInventory().canExtractItem(slot, stack, side);
    }

    public void markDirty() {
    }

    protected abstract IInventoryAdapter getInternalInventory();
}

