/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.blocks.BlockForestry;
import forestry.core.circuits.ISocketable;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.utils.InventoryUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class BlockStructure
extends BlockForestry {
    private long previousMessageTick = 0L;

    protected BlockStructure(Material material) {
        super(material);
        this.setHardness(1.0f);
    }

    public boolean canSilkHarvest() {
        return false;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.isSneaking()) {
            return false;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof MultiblockTileEntityForestry)) {
            return false;
        }
        MultiblockTileEntityForestry part = (MultiblockTileEntityForestry)tile;
        IMultiblockController controller = part.getMultiblockLogic().getController();
        if (player.getCurrentEquippedItem() == null && !controller.isAssembled()) {
            if (controller != null) {
                String validationError = controller.getLastValidationError();
                if (validationError != null) {
                    long tick = world.getTotalWorldTime();
                    if (tick > this.previousMessageTick + 20L) {
                        player.addChatMessage((IChatComponent)new ChatComponentText(validationError));
                        this.previousMessageTick = tick;
                    }
                    return true;
                }
            } else {
                player.addChatMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocal((String)"for.multiblock.error.notConnected")));
                return true;
            }
        }
        if (controller == null || !controller.isAssembled()) {
            return false;
        }
        if (!world.isRemote) {
            part.openGui(player);
        }
        return true;
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLivingBase entityLiving, ItemStack itemstack) {
        TileEntity tile;
        if (world.isRemote) {
            return;
        }
        if (entityLiving instanceof EntityPlayer && (tile = world.getTileEntity(i, j, k)) instanceof MultiblockTileEntityForestry) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            GameProfile gameProfile = player.getGameProfile();
            ((MultiblockTileEntityForestry)tile).setOwner(gameProfile);
        }
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        IMultiblockComponent part;
        if (world.isRemote) {
            return;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IMultiblockComponent && MultiblockUtil.getNeighboringParts(world, part = (IMultiblockComponent)tile).size() == 0) {
            if (tile instanceof IInventory) {
                InventoryUtil.dropInventory((IInventory)tile, world, x, y, z);
            }
            if (tile instanceof ISocketable) {
                InventoryUtil.dropSockets((ISocketable)tile, world, x, y, z);
            }
        }
        super.breakBlock(world, x, y, z, block, meta);
    }
}

