/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.access;

import com.mojang.authlib.GameProfile;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IAccessOwnerListener;
import forestry.core.access.IRestrictedAccess;
import forestry.core.config.Config;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.packets.PacketAccessSwitch;
import forestry.core.network.packets.PacketAccessSwitchEntity;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.ILocatable;
import forestry.core.utils.PlayerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.World;

public final class AccessHandler
implements IAccessHandler {
    private final IRestrictedAccess accessListener;
    private final List<IAccessOwnerListener> accessOwnerListeners = new ArrayList<IAccessOwnerListener>();
    private final Object target;
    private GameProfile owner = null;
    private EnumAccess access = EnumAccess.SHARED;

    public <T extends IRestrictedAccess & ILocatable> AccessHandler(T tile) {
        this.accessListener = tile;
        this.target = tile;
    }

    public <T extends Entity> AccessHandler(T entity) {
        this.accessListener = (IRestrictedAccess)entity;
        this.target = entity;
    }

    @Override
    public void addOwnerListener(IAccessOwnerListener accessListener) {
        this.accessOwnerListeners.add(accessListener);
    }

    @Override
    public void removeOwnerListener(IAccessOwnerListener accessListener) {
        this.accessOwnerListeners.remove(accessListener);
    }

    @Override
    public final boolean allowsRemoval(EntityPlayer player) {
        return !Config.enablePermissions || this.getAccess() == EnumAccess.SHARED || !this.isOwned() || this.isOwner(player) || Proxies.common.isOp(player);
    }

    @Override
    public final boolean allowsAlteration(EntityPlayer player) {
        return this.allowsRemoval(player);
    }

    @Override
    public final boolean allowsViewing(EntityPlayer player) {
        return this.allowsAlteration(player) || this.getAccess() == EnumAccess.VIEWABLE;
    }

    @Override
    public final boolean allowsPipeConnections() {
        return this.access == EnumAccess.SHARED;
    }

    @Override
    public EnumAccess getAccess() {
        return this.access;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(GameProfile owner) {
        this.owner = owner;
        for (IAccessOwnerListener listener : this.accessOwnerListeners) {
            listener.onOwnerSet(owner);
        }
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return PlayerUtil.isSameGameProfile(this.owner, player.getGameProfile());
    }

    @Override
    public boolean switchAccess(EntityPlayer player) {
        if (!this.isOwner(player)) {
            return false;
        }
        int ordinal = (this.access.ordinal() + 1) % EnumAccess.values().length;
        EnumAccess newAccess = EnumAccess.values()[ordinal];
        this.setAccess(player.worldObj, newAccess);
        return true;
    }

    private void setAccess(World world, EnumAccess access) {
        EnumAccess oldAccess = this.access;
        if (oldAccess == access) {
            return;
        }
        this.access = access;
        if (world.isRemote) {
            if (this.target instanceof ILocatable) {
                Proxies.net.sendToServer(new PacketAccessSwitch((ILocatable)this.target));
            } else if (this.target instanceof Entity) {
                Proxies.net.sendToServer(new PacketAccessSwitchEntity((Entity)this.target));
            }
        } else {
            this.accessListener.onSwitchAccess(oldAccess, access);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        if (this.owner == null) {
            data.writeByte(-1);
        } else {
            data.writeByte(this.access.ordinal());
            data.writeLong(this.owner.getId().getMostSignificantBits());
            data.writeLong(this.owner.getId().getLeastSignificantBits());
            data.writeUTF(this.owner.getName());
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        byte accessOrdinal = data.readByte();
        if (accessOrdinal >= 0) {
            this.access = EnumAccess.values()[accessOrdinal];
            GameProfile owner = new GameProfile(new UUID(data.readLong(), data.readLong()), data.readUTF());
            this.setOwner(owner);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.access = EnumAccess.values()[data.getInteger("Access")];
        if (data.hasKey("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)data.getCompoundTag("owner"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.setInteger("Access", this.access.ordinal());
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            data.setTag("owner", (NBTBase)nbt);
        }
    }
}

