/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenIpe
extends WorldGenTree {
    public WorldGenIpe(ITreeGenData tree) {
        super(tree, 6, 4);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height + 1;
        float adjustedGirth = (float)this.girth * 0.65f;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.2f * adjustedGirth, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.2f * adjustedGirth, 1, this.leaf);
        ArrayList<ChunkCoordinates> branchCoords = new ArrayList<ChunkCoordinates>();
        while (leafSpawn > 2) {
            int radius = Math.round(adjustedGirth * (float)(this.height - leafSpawn) / 1.5f);
            branchCoords.addAll(this.generateBranches(world, leafSpawn, 0, 0, 0.25f, 0.25f, radius, 2));
            leafSpawn -= 2;
        }
        for (ChunkCoordinates branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd.posY, branchEnd.posX, branchEnd.posZ, 2.0f, 2, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
    }
}

