/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.api.arboriculture.EnumWoodType;
import forestry.arboriculture.items.ItemBlockWood;
import forestry.arboriculture.render.IconProviderWood;
import forestry.core.utils.ItemStackUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderSlabItem
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                RenderSlabItem.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f, true);
                break;
            }
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: {
                RenderSlabItem.renderItem((RenderBlocks)data[0], item, 0.5f, 0.5f, 0.5f, true);
                break;
            }
            case INVENTORY: {
                RenderSlabItem.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f, false);
                break;
            }
        }
    }

    private static void renderItem(RenderBlocks renderer, ItemStack itemStack, float x, float y, float z, boolean fullBlock) {
        Tessellator tessellator = Tessellator.instance;
        Block block = ItemStackUtil.getBlock(itemStack);
        if (!(itemStack.getItem() instanceof ItemBlockWood) || block == null) {
            return;
        }
        EnumWoodType woodType = ItemBlockWood.getWoodType(itemStack);
        IIcon plankIcon = IconProviderWood.getPlankIcon(woodType);
        if (plankIcon == null) {
            return;
        }
        GL11.glTranslatef((float)x, (float)y, (float)z);
        block.setBlockBoundsForItemRender();
        renderer.setRenderBoundsFromBlock(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, plankIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, plankIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, plankIcon);
        tessellator.draw();
        if (fullBlock) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, plankIcon);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, plankIcon);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, plankIcon);
            tessellator.draw();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

