/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gui;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.arboriculture.inventory.ItemInventoryTreealyzer;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.genetics.alleles.AllelePlantType;
import forestry.core.gui.ContainerAlyzer;
import forestry.core.gui.GuiAlyzer;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.EnumPlantType;

public class GuiTreealyzer
extends GuiAlyzer {
    public GuiTreealyzer(EntityPlayer player, ItemInventoryTreealyzer inventory) {
        super(TreeManager.treeRoot, player, new ContainerAlyzer(inventory, player), inventory, "gui.treealyzer");
        ArrayList treeList = new ArrayList();
        PluginArboriculture.items.sapling.addCreativeItems(treeList, false);
        for (ItemStack treeStack : treeList) {
            IAlleleTreeSpecies species = TreeGenome.getSpecies(treeStack);
            if (species == null) continue;
            this.iconStacks.put(species.getUID(), treeStack);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        int page = 0;
        ITree tree = null;
        EnumGermlingType treeType = EnumGermlingType.SAPLING;
        for (int k = 1; k < 7; ++k) {
            if (k == 5 || this.inventory.getStackInSlot(k) == null) continue;
            tree = TreeManager.treeRoot.getMember(this.inventory.getStackInSlot(k));
            treeType = TreeManager.treeRoot.getType(this.inventory.getStackInSlot(k));
            if (tree == null || !tree.isAnalyzed()) continue;
            page = k;
            break;
        }
        switch (page) {
            case 1: {
                this.drawAnalyticsPage1(tree, treeType);
                break;
            }
            case 2: {
                this.drawAnalyticsPage2(tree);
                break;
            }
            case 3: {
                this.drawAnalyticsPage3(tree);
                break;
            }
            case 4: {
                this.drawAnalyticsPageMutations(tree);
                break;
            }
            case 6: {
                this.drawAnalyticsPageClassification(tree);
                break;
            }
            default: {
                this.drawAnalyticsOverview();
            }
        }
    }

    private void drawAnalyticsPage1(ITree tree, EnumGermlingType type) {
        this.textLayout.startPage(12, 90, 155);
        this.textLayout.drawLine(StringUtil.localize("gui.active"), 90);
        this.textLayout.drawLine(StringUtil.localize("gui.inactive"), 155);
        this.textLayout.newLine();
        this.textLayout.newLine();
        String customPrimaryTreeKey = "trees.custom.treealyzer." + type.getName() + "." + tree.getGenome().getPrimary().getUnlocalizedName().replace("trees.species.", "");
        String customSecondaryTreeKey = "trees.custom.treealyzer." + type.getName() + "." + tree.getGenome().getSecondary().getUnlocalizedName().replace("trees.species.", "");
        this.drawSpeciesRow(StringUtil.localize("gui.species"), tree, EnumTreeChromosome.SPECIES, GuiTreealyzer.checkCustomName(customPrimaryTreeKey), GuiTreealyzer.checkCustomName(customSecondaryTreeKey));
        this.textLayout.newLine();
        this.drawChromosomeRow(StringUtil.localize("gui.saplings"), tree, EnumTreeChromosome.FERTILITY);
        this.textLayout.newLineCompressed();
        this.drawChromosomeRow(StringUtil.localize("gui.maturity"), tree, EnumTreeChromosome.MATURATION);
        this.textLayout.newLineCompressed();
        this.drawChromosomeRow(StringUtil.localize("gui.height"), tree, EnumTreeChromosome.HEIGHT);
        this.textLayout.newLineCompressed();
        IAlleleInteger activeGirth = (IAlleleInteger)tree.getGenome().getActiveAllele(EnumTreeChromosome.GIRTH);
        IAlleleInteger inactiveGirth = (IAlleleInteger)tree.getGenome().getInactiveAllele(EnumTreeChromosome.GIRTH);
        this.textLayout.drawLine(StringUtil.localize("gui.girth"), 12);
        this.drawLine(String.format("%sx%s", activeGirth.getValue(), activeGirth.getValue()), 90, tree, EnumTreeChromosome.GIRTH, false);
        this.drawLine(String.format("%sx%s", inactiveGirth.getValue(), inactiveGirth.getValue()), 155, tree, EnumTreeChromosome.GIRTH, true);
        this.textLayout.newLineCompressed();
        this.drawChromosomeRow(StringUtil.localize("gui.yield"), tree, EnumTreeChromosome.YIELD);
        this.textLayout.newLineCompressed();
        this.drawChromosomeRow(StringUtil.localize("gui.sappiness"), tree, EnumTreeChromosome.SAPPINESS);
        this.textLayout.newLineCompressed();
        String yes = StringUtil.localize("yes");
        String no = StringUtil.localize("no");
        AlleleBoolean primaryFireproof = (AlleleBoolean)tree.getGenome().getActiveAllele(EnumTreeChromosome.FIREPROOF);
        AlleleBoolean secondaryFireproof = (AlleleBoolean)tree.getGenome().getInactiveAllele(EnumTreeChromosome.FIREPROOF);
        this.textLayout.drawLine(StringUtil.localize("gui.fireproof"), 12);
        this.drawLine(StringUtil.readableBoolean(primaryFireproof.getValue(), yes, no), 90, tree, EnumTreeChromosome.FIREPROOF, false);
        this.drawLine(StringUtil.readableBoolean(secondaryFireproof.getValue(), yes, no), 155, tree, EnumTreeChromosome.FIREPROOF, false);
        this.textLayout.newLineCompressed();
        this.drawChromosomeRow(StringUtil.localize("gui.effect"), tree, EnumTreeChromosome.EFFECT);
        this.textLayout.endPage();
    }

    private void drawAnalyticsPage2(ITree tree) {
        this.textLayout.startPage();
        int speciesDominance0 = this.getColorCoding(tree.getGenome().getPrimary().isDominant());
        int speciesDominance1 = this.getColorCoding(tree.getGenome().getSecondary().isDominant());
        this.textLayout.drawLine(StringUtil.localize("gui.active"), 90);
        this.textLayout.drawLine(StringUtil.localize("gui.inactive"), 155);
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.drawLine(StringUtil.localize("gui.growth"), 12);
        this.drawLine(tree.getGenome().getGrowthProvider().getDescription(), 90, tree, EnumTreeChromosome.GROWTH, false);
        this.drawLine(((IAlleleGrowth)tree.getGenome().getInactiveAllele(EnumTreeChromosome.GROWTH)).getProvider().getDescription(), 155, tree, EnumTreeChromosome.GROWTH, true);
        this.textLayout.newLine();
        this.textLayout.drawLine(StringUtil.localize("gui.native"), 12);
        this.textLayout.drawLine(StringUtil.localize("gui." + tree.getGenome().getPrimary().getPlantType().toString().toLowerCase(Locale.ENGLISH)), 90, speciesDominance0);
        this.textLayout.drawLine(StringUtil.localize("gui." + tree.getGenome().getSecondary().getPlantType().toString().toLowerCase(Locale.ENGLISH)), 155, speciesDominance1);
        this.textLayout.newLine();
        this.textLayout.drawLine(StringUtil.localize("gui.tolerated"), 12);
        ArrayList<EnumPlantType> activeTolerated = new ArrayList<EnumPlantType>(tree.getGenome().getPlantTypes());
        List inactiveTolerated = Collections.emptyList();
        IAllele inactiveAllelePlant = tree.getGenome().getInactiveAllele(EnumTreeChromosome.PLANT);
        if (inactiveAllelePlant instanceof AllelePlantType) {
            inactiveTolerated = new ArrayList<EnumPlantType>(((AllelePlantType)inactiveAllelePlant).getPlantTypes());
        }
        int max = Math.max(activeTolerated.size(), inactiveTolerated.size());
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                this.textLayout.newLine();
            }
            if (activeTolerated.size() > i) {
                this.drawLine(StringUtil.localize("gui." + ((EnumPlantType)activeTolerated.get(i)).toString().toLowerCase(Locale.ENGLISH)), 90, tree, EnumTreeChromosome.PLANT, false);
            }
            if (inactiveTolerated.size() <= i) continue;
            this.drawLine(StringUtil.localize("gui." + ((EnumPlantType)inactiveTolerated.get(i)).toString().toLowerCase(Locale.ENGLISH)), 155, tree, EnumTreeChromosome.PLANT, true);
        }
        this.textLayout.newLine();
        this.textLayout.drawLine(StringUtil.localize("gui.supports"), 12);
        ArrayList<IFruitFamily> families0 = new ArrayList<IFruitFamily>(tree.getGenome().getPrimary().getSuitableFruit());
        ArrayList<IFruitFamily> families1 = new ArrayList<IFruitFamily>(tree.getGenome().getSecondary().getSuitableFruit());
        max = Math.max(families0.size(), families1.size());
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                this.textLayout.newLine();
            }
            if (families0.size() > i) {
                this.textLayout.drawLine(((IFruitFamily)families0.get(i)).getName(), 90, speciesDominance0);
            }
            if (families1.size() <= i) continue;
            this.textLayout.drawLine(((IFruitFamily)families1.get(i)).getName(), 155, speciesDominance1);
        }
        this.textLayout.newLine();
        this.textLayout.newLine();
        int fruitDominance0 = this.getColorCoding(tree.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS).isDominant());
        int fruitDominance1 = this.getColorCoding(tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS).isDominant());
        this.textLayout.drawLine(StringUtil.localize("gui.fruits"), 12);
        String strike = "";
        IAllele fruit0 = tree.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS);
        if (!tree.canBearFruit() && fruit0 != AlleleFruit.fruitNone) {
            strike = EnumChatFormatting.STRIKETHROUGH.toString();
        }
        this.textLayout.drawLine(strike + StringUtil.localize(tree.getGenome().getFruitProvider().getDescription()), 90, fruitDominance0);
        strike = "";
        IAllele fruit1 = tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS);
        if (!tree.getGenome().getSecondary().getSuitableFruit().contains(((IAlleleFruit)fruit1).getProvider().getFamily()) && fruit1 != AlleleFruit.fruitNone) {
            strike = EnumChatFormatting.STRIKETHROUGH.toString();
        }
        this.textLayout.drawLine(strike + StringUtil.localize(((IAlleleFruit)fruit1).getProvider().getDescription()), 155, fruitDominance1);
        this.textLayout.newLine();
        this.textLayout.drawLine(StringUtil.localize("gui.family"), 12);
        IFruitFamily primary = tree.getGenome().getFruitProvider().getFamily();
        IFruitFamily secondary = ((IAlleleFruit)tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS)).getProvider().getFamily();
        if (primary != null) {
            this.textLayout.drawLine(primary.getName(), 90, fruitDominance0);
        }
        if (secondary != null) {
            this.textLayout.drawLine(secondary.getName(), 155, fruitDominance1);
        }
        this.textLayout.endPage();
    }

    private void drawAnalyticsPage3(ITree tree) {
        this.textLayout.startPage(12, 90, 155);
        this.textLayout.drawLine(StringUtil.localize("gui.beealyzer.produce") + ":", 12);
        this.textLayout.newLine();
        int x = 12;
        for (ItemStack stack : tree.getProduceList()) {
            itemRender.renderItemIntoGUI(this.fontRendererObj, this.mc.renderEngine, stack, this.guiLeft + x, this.guiTop + this.textLayout.getLineY());
            if ((x += 18) <= 148) continue;
            x = 12;
            this.textLayout.newLine();
        }
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.drawLine(StringUtil.localize("gui.beealyzer.specialty") + ":", 12);
        this.textLayout.newLine();
        x = 12;
        for (ItemStack stack : tree.getSpecialtyList()) {
            itemRender.renderItemIntoGUI(this.fontRendererObj, this.mc.renderEngine, stack, this.guiLeft + x, this.guiTop + this.textLayout.getLineY());
            if ((x += 18) <= 148) continue;
            x = 12;
            this.textLayout.newLine();
        }
        this.textLayout.endPage();
    }
}

