/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.render.IconProviderWood;
import forestry.arboriculture.tiles.TileWood;
import forestry.core.render.ParticleHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockWood
extends Block
implements ITileEntityProvider,
IWoodTyped {
    private final ParticleHelper.Callback particleCallback;
    private final String blockKind;
    private final boolean fireproof;
    private final ThreadLocal<ArrayList<ItemStack>> drops = new ThreadLocal();

    protected BlockWood(String blockKind, boolean fireproof) {
        super(Material.wood);
        this.blockKind = blockKind;
        this.fireproof = fireproof;
        this.setStepSound(soundTypeWood);
        this.setCreativeTab(Tabs.tabArboriculture);
        this.particleCallback = new ParticleHelper.DefaultCallback(this);
    }

    @Override
    public final String getBlockKind() {
        return this.blockKind;
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerBlockIcons(IIconRegister register) {
        IconProviderWood.registerIcons(register);
    }

    public final TileEntity createNewTileEntity(World world, int meta) {
        return new TileWood();
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return TileWood.getPickBlock(this, (IBlockAccess)world, x, y, z);
    }

    public void onBlockHarvested(World world, int x, int y, int z, int meta, EntityPlayer playerProfile) {
        this.drops.set(TileWood.getDrops(this, world, x, y, z));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = this.drops.get();
        this.drops.remove();
        if (ret == null) {
            ret = TileWood.getDrops(this, world, x, y, z);
        }
        return ret;
    }

    public final float getBlockHardness(World world, int x, int y, int z) {
        TileWood wood = TileWood.getWoodTile((IBlockAccess)world, x, y, z);
        if (wood == null) {
            return 2.0f;
        }
        return wood.getWoodType().getHardness();
    }

    public final boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return !this.isFireproof();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 5;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IIcon getIcon(IBlockAccess var1, int var2, int var3, int var4, int var5);

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addHitEffects(worldObj, this, target, effectRenderer, this.particleCallback);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addDestroyEffects(worldObj, this, x, y, z, meta, effectRenderer, this.particleCallback);
    }
}

