/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.blocks.BlockTreeContainer;
import forestry.arboriculture.tiles.TileSapling;
import forestry.core.render.TextureManager;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSapling
extends BlockTreeContainer
implements IGrowable {
    @SideOnly(value=Side.CLIENT)
    private static IIcon defaultIcon;

    public static TileSapling getSaplingTile(IBlockAccess world, int x, int y, int z) {
        return TileUtil.getTile(world, x, y, z, TileSapling.class);
    }

    public BlockSapling() {
        super(Material.plants);
        float factor = 0.4f;
        this.setBlockBounds(0.5f - factor, 0.0f, 0.5f - factor, 0.5f + factor, factor * 2.0f, 0.5f + factor);
        this.setStepSound(soundTypeGrass);
    }

    public TileEntity createNewTileEntity(World var1, int meta) {
        return new TileSapling();
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return PluginArboriculture.modelIdSaplings;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        defaultIcon = TextureManager.registerTex(register, "germlings/sapling.treeBalsa");
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (allele instanceof IAlleleTreeSpecies) {
                ((IAlleleTreeSpecies)allele).getIconProvider().registerIcons(register);
            }
            if (!(allele instanceof IAlleleFruit)) continue;
            ((IAlleleFruit)allele).getProvider().registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        return defaultIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileSapling sapling = BlockSapling.getSaplingTile(world, x, y, z);
        if (sapling == null) {
            return defaultIcon;
        }
        if (sapling.getTree() == null) {
            return defaultIcon;
        }
        return sapling.getTree().getGenome().getPrimary().getGermlingIcon(EnumGermlingType.SAPLING, 0);
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        TileSapling tile = BlockSapling.getSaplingTile((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return false;
        }
        if (tile.getTree() == null) {
            return false;
        }
        return tile.getTree().canStay(world, x, y, z);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighbour) {
        super.onNeighborBlockChange(world, x, y, z, neighbour);
        if (!world.isRemote && !this.canBlockStay(world, x, y, z)) {
            BlockSapling.dropAsSapling(world, x, y, z);
            world.setBlockToAir(x, y, z);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileSapling sapling = BlockSapling.getSaplingTile((IBlockAccess)world, x, y, z);
        if (sapling == null || sapling.getTree() == null) {
            return null;
        }
        return TreeManager.treeRoot.getMemberStack(sapling.getTree(), EnumGermlingType.SAPLING.ordinal());
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!world.isRemote && this.canHarvestBlock(player, world.getBlockMetadata(x, y, z)) && !player.capabilities.isCreativeMode) {
            BlockSapling.dropAsSapling(world, x, y, z);
        }
        return world.setBlockToAir(x, y, z);
    }

    private static void dropAsSapling(World world, int x, int y, int z) {
        if (world.isRemote) {
            return;
        }
        TileSapling sapling = BlockSapling.getSaplingTile((IBlockAccess)world, x, y, z);
        if (sapling != null && sapling.getTree() != null) {
            ItemStack saplingStack = TreeManager.treeRoot.getMemberStack(sapling.getTree(), EnumGermlingType.SAPLING.ordinal());
            ItemStackUtil.dropItemStackAsEntity(saplingStack, world, x, y, z);
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        TileSapling saplingTile = BlockSapling.getSaplingTile((IBlockAccess)world, x, y, z);
        if (saplingTile != null) {
            return saplingTile.canAcceptBoneMeal();
        }
        return true;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return world.rand.nextFloat() < 0.45f;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        TileSapling saplingTile = BlockSapling.getSaplingTile((IBlockAccess)world, x, y, z);
        if (saplingTile != null) {
            saplingTile.tryGrow(true);
        }
    }
}

