/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.InventoryUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;

public class TileSwarm
extends TileEntity {
    public final InventoryAdapter contained = new InventoryAdapter(2, "Contained");
    private boolean updatedLight;

    public boolean canUpdate() {
        return true;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote && !this.updatedLight && this.worldObj.getWorldTime() % 20L == 0L) {
            this.updatedLight = this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public TileSwarm setContained(ItemStack[] bees) {
        for (ItemStack itemstack : bees) {
            InventoryUtil.addStack((IInventory)this.contained, itemstack, true);
        }
        return this;
    }

    public boolean containsBees() {
        for (int i = 0; i < this.contained.getSizeInventory(); ++i) {
            if (this.contained.getStackInSlot(i) == null) continue;
            return true;
        }
        return false;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.contained.readFromNBT(nbttagcompound);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.contained.writeToNBT(nbttagcompound);
    }
}

