/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorLogic;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.gui.ContainerAlveary;
import forestry.apiculture.gui.GuiAlveary;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.ITitled;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class TileAlveary
extends MultiblockTileEntityForestry<MultiblockLogicAlveary>
implements IBeeHousing,
IAlvearyComponent,
IRestrictedAccess,
IStreamableGui,
ITitled,
IClimatised,
IHintSource {
    private final String unlocalizedTitle;

    protected TileAlveary() {
        this(BlockAlveary.Type.PLAIN);
    }

    protected TileAlveary(BlockAlveary.Type type) {
        super(new MultiblockLogicAlveary());
        this.unlocalizedTitle = "tile.for.alveary." + type.ordinal() + ".name";
    }

    public int getIcon(int side) {
        return 0;
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, ChunkCoordinates minCoord, ChunkCoordinates maxCoord) {
        if (this.worldObj.isRemote) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
        this.markDirty();
    }

    @Override
    public void onMachineBroken() {
        if (this.worldObj.isRemote) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
        this.markDirty();
    }

    @Override
    public BiomeGenBase getBiome() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBiome();
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeModifiers();
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeListeners();
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeInventory();
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeekeepingLogic();
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeFXCoordinates();
    }

    @Override
    public EnumTemperature getTemperature() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getTemperature();
    }

    @Override
    public EnumHumidity getHumidity() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getHumidity();
    }

    @Override
    public int getBlockLightValue() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBlockLightValue();
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().canBlockSeeTheSky();
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getErrorLogic();
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getAccessHandler();
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().onSwitchAccess(oldAccess, newAccess);
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getInternalInventory();
    }

    @Override
    public String getUnlocalizedTitle() {
        return this.unlocalizedTitle;
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"apiary");
    }

    @Override
    public float getExactTemperature() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getExactTemperature();
    }

    @Override
    public float getExactHumidity() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getExactHumidity();
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().writeGuiData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().readGuiData(data);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiAlveary(player.inventory, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        BeeManager.beeRoot.syncBreedingTrackerToPlayer(player);
        return new ContainerAlveary(player.inventory, this);
    }
}

