/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.apiculture.gui.ContainerHabitatLocator;
import forestry.apiculture.gui.GuiHabitatLocator;
import forestry.apiculture.inventory.ItemInventoryHabitatLocator;
import forestry.apiculture.items.HabitatLocatorLogic;
import forestry.apiculture.render.TextureHabitatLocator;
import forestry.core.items.ItemWithGui;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class ItemHabitatLocator
extends ItemWithGui {
    private static final String iconName = "forestry:biomefinder";
    private final HabitatLocatorLogic locatorLogic;

    public ItemHabitatLocator() {
        super(Tabs.tabApiculture);
        this.setMaxStackSize(1);
        this.locatorLogic = new HabitatLocatorLogic();
    }

    public HabitatLocatorLogic getLocatorLogic() {
        return this.locatorLogic;
    }

    public void onUpdate(ItemStack p_77663_1_, World world, Entity player, int p_77663_4_, boolean p_77663_5_) {
        if (!world.isRemote) {
            this.locatorLogic.onUpdate(world, player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        if (register instanceof TextureMap) {
            TextureHabitatLocator texture = new TextureHabitatLocator(iconName);
            ((TextureMap)register).setTextureEntry(iconName, (TextureAtlasSprite)texture);
            this.itemIcon = texture;
        }
    }

    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        BiomeGenBase currentBiome = player.worldObj.getBiomeGenForCoords((int)player.posX, (int)player.posZ);
        float temperatureValue = currentBiome.getFloatTemperature((int)player.posX, (int)player.posY, (int)player.posZ);
        EnumTemperature temperature = EnumTemperature.getFromValue(temperatureValue);
        EnumHumidity humidity = EnumHumidity.getFromValue(currentBiome.rainfall);
        list.add(StringUtil.localize("gui.currentBiome") + ": " + currentBiome.biomeName);
        list.add(StringUtil.localize("gui.temperature") + ": " + AlleleManager.climateHelper.toDisplay(temperature));
        list.add(StringUtil.localize("gui.humidity") + ": " + AlleleManager.climateHelper.toDisplay(humidity));
    }

    @Override
    public Object getGui(EntityPlayer player, ItemStack heldItem, int data) {
        return new GuiHabitatLocator(player, new ItemInventoryHabitatLocator(player, heldItem));
    }

    @Override
    public Object getContainer(EntityPlayer player, ItemStack heldItem, int data) {
        return new ContainerHabitatLocator(player, new ItemInventoryHabitatLocator(player, heldItem));
    }
}

