/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.inventory;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.IHiveFrame;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.inventory.IApiaryInventory;
import forestry.core.access.IAccessHandler;
import forestry.core.utils.SlotUtil;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InventoryApiary
extends InventoryBeeHousing
implements IApiaryInventory {
    public static final int SLOT_FRAMES_1 = 9;
    public static final int SLOT_FRAMES_COUNT = 3;

    public InventoryApiary(IAccessHandler accessHandler) {
        super(12, "Items", accessHandler);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (SlotUtil.isSlotInRange(slotIndex, 9, 3)) {
            return itemStack.getItem() instanceof IHiveFrame && this.getStackInSlot(slotIndex) == null;
        }
        return super.canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        if (SlotUtil.isSlotInRange(slotIndex, 9, 3)) {
            return false;
        }
        return super.isItemValidForSlot(slotIndex, itemStack);
    }

    public Collection<IHiveFrame> getFrames() {
        ArrayList<IHiveFrame> hiveFrames = new ArrayList<IHiveFrame>(3);
        for (int i = 9; i < 12; ++i) {
            Item itemInSlot;
            ItemStack stackInSlot = this.getStackInSlot(i);
            if (stackInSlot == null || !((itemInSlot = stackInSlot.getItem()) instanceof IHiveFrame)) continue;
            hiveFrames.add((IHiveFrame)itemInSlot);
        }
        return hiveFrames;
    }

    @Override
    public void wearOutFrames(IBeeHousing beeHousing, int amount) {
        IBeekeepingMode beekeepingMode = BeeManager.beeRoot.getBeekeepingMode(beeHousing.getWorld());
        int wear = Math.round((float)amount * beekeepingMode.getWearModifier());
        for (int i = 9; i < 12; ++i) {
            Item hiveFrameItem;
            ItemStack hiveFrameStack = this.getStackInSlot(i);
            if (hiveFrameStack == null || !((hiveFrameItem = hiveFrameStack.getItem()) instanceof IHiveFrame)) continue;
            IHiveFrame hiveFrame = (IHiveFrame)hiveFrameItem;
            ItemStack queenStack = this.getQueen();
            IBee queen = BeeManager.beeRoot.getMember(queenStack);
            ItemStack usedFrame = hiveFrame.frameUsed(beeHousing, hiveFrameStack, queen, wear);
            this.setInventorySlotContents(i, usedFrame);
        }
    }
}

