/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.utils.DamageSourceForestry;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;

public class AlleleEffectAggressive
extends AlleleEffectThrottled {
    private static final DamageSource damageSourceBeeAggressive = new DamageSourceForestry("bee.aggressive");

    public AlleleEffectAggressive() {
        super("aggressive", true, 40, false, false);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        List<EntityLivingBase> entities = AlleleEffectAggressive.getEntitiesInRange(genome, housing, EntityLivingBase.class);
        for (EntityLivingBase entity : entities) {
            int damage = 4;
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, this.getUID(), true);
            if ((damage -= count) <= 0) continue;
            entity.attackEntityFrom(damageSourceBeeAggressive, (float)damage);
        }
        return storedData;
    }
}

