/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import com.google.common.base.Objects;
import forestry.api.genetics.IFlower;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;

final class Flower
implements IFlower {
    private final Block block;
    private final int meta;
    private Double weight;

    public Flower(Block block, int meta, double weight) {
        this.block = block;
        this.meta = meta;
        this.weight = weight;
    }

    @Override
    public boolean isPlantable() {
        return this.weight != 0.0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IFlower)) {
            return false;
        }
        IFlower flower = (IFlower)obj;
        return Block.isEqualTo((Block)this.block, (Block)flower.getBlock()) && (this.meta == Short.MAX_VALUE || flower.getMeta() == Short.MAX_VALUE || this.meta == flower.getMeta());
    }

    @Override
    public int compareTo(@Nonnull IFlower other) {
        return this.weight.compareTo(other.getWeight());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.block});
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("block", (Object)this.block).add("meta", this.meta).add("weight", (Object)this.weight).toString();
    }
}

