/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.apiculture.MaterialBeehive;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.multiblock.TileAlvearyFan;
import forestry.apiculture.multiblock.TileAlvearyHeater;
import forestry.apiculture.multiblock.TileAlvearyHygroregulator;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearyStabiliser;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.core.blocks.BlockStructure;
import forestry.core.render.TextureManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAlveary
extends BlockStructure {
    public static final int PLAIN = 0;
    public static final int ENTRANCE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int ALVEARY_SWARMER_OFF = 5;
    public static final int ALVEARY_SWARMER_ON = 6;
    public static final int ALVEARY_HEATER_OFF = 7;
    public static final int ALVEARY_HEATER_ON = 8;
    public static final int ALVEARY_FAN_OFF = 9;
    public static final int ALVEARY_FAN_ON = 10;
    public static final int ALVEARY_HYGRO = 11;
    public static final int STABILISER = 12;
    public static final int SIEVE = 13;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockAlveary() {
        super(new MaterialBeehive(false));
        this.setHardness(1.0f);
        this.setCreativeTab(Tabs.tabApiculture);
        this.setHarvestLevel("axe", 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 8; ++i) {
            if (i == 1) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int getRenderType() {
        return 0;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        drop.add(new ItemStack((Block)this, 1, metadata != 1 ? metadata : 0));
        return drop;
    }

    public int getDamageValue(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return meta != 1 ? meta : 0;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata < 0 || metadata > Type.VALUES.length) {
            return null;
        }
        Type type = Type.VALUES[metadata];
        switch (type) {
            case SWARMER: {
                return new TileAlvearySwarmer();
            }
            case FAN: {
                return new TileAlvearyFan();
            }
            case HEATER: {
                return new TileAlvearyHeater();
            }
            case HYGRO: {
                return new TileAlvearyHygroregulator();
            }
            case STABILIZER: {
                return new TileAlvearyStabiliser();
            }
            case SIEVE: {
                return new TileAlvearySieve();
            }
        }
        return new TileAlvearyPlain();
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return this.createTileEntity(world, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.icons = new IIcon[14];
        this.icons[0] = TextureManager.registerTex(register, "apiculture/alveary.plain");
        this.icons[1] = TextureManager.registerTex(register, "apiculture/alveary.entrance");
        this.icons[2] = TextureManager.registerTex(register, "apiculture/alveary.bottom");
        this.icons[3] = TextureManager.registerTex(register, "apiculture/alveary.left");
        this.icons[4] = TextureManager.registerTex(register, "apiculture/alveary.right");
        this.icons[5] = TextureManager.registerTex(register, "apiculture/alveary.swarmer.off");
        this.icons[6] = TextureManager.registerTex(register, "apiculture/alveary.swarmer.on");
        this.icons[7] = TextureManager.registerTex(register, "apiculture/alveary.heater.off");
        this.icons[8] = TextureManager.registerTex(register, "apiculture/alveary.heater.on");
        this.icons[9] = TextureManager.registerTex(register, "apiculture/alveary.fan.off");
        this.icons[10] = TextureManager.registerTex(register, "apiculture/alveary.fan.on");
        this.icons[11] = TextureManager.registerTex(register, "apiculture/alveary.valve");
        this.icons[12] = TextureManager.registerTex(register, "apiculture/alveary.stabiliser");
        this.icons[13] = TextureManager.registerTex(register, "apiculture/alveary.sieve");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        if (!(metadata > 1 && metadata != Type.SIEVE.ordinal() && metadata != Type.SWARMER.ordinal() && metadata != Type.STABILIZER.ordinal() || side != 1 && side != 0)) {
            return this.icons[2];
        }
        Type type = Type.VALUES[metadata];
        switch (type) {
            case PLAIN: {
                return this.icons[0];
            }
            case ENTRANCE: {
                return this.icons[1];
            }
            case SWARMER: {
                return this.icons[5];
            }
            case FAN: {
                return this.icons[9];
            }
            case HEATER: {
                return this.icons[7];
            }
            case HYGRO: {
                return this.icons[11];
            }
            case STABILIZER: {
                return this.icons[12];
            }
            case SIEVE: {
                return this.icons[13];
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 1) {
            return this.getIcon(side, meta);
        }
        if (meta > 1) {
            return this.getBlockTextureFromSideAndTile(world, x, y, z, side);
        }
        Block blockXP = world.getBlock(x + 1, y, z);
        Block blockXM = world.getBlock(x - 1, y, z);
        if (blockXP == this && blockXM != this) {
            if (world.getBlockMetadata(x + 1, y, z) == 1) {
                if (world.getBlock(x, y, z + 1) != this) {
                    return this.switchForSide(42, side);
                }
                return this.switchForSide(41, side);
            }
            return this.getIcon(side, meta);
        }
        if (blockXP != this && blockXM == this) {
            if (world.getBlockMetadata(x - 1, y, z) == 1) {
                if (world.getBlock(x, y, z + 1) != this) {
                    return this.switchForSide(41, side);
                }
                return this.switchForSide(42, side);
            }
            return this.getIcon(side, meta);
        }
        return this.getIcon(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    private IIcon getBlockTextureFromSideAndTile(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof TileAlveary)) {
            return this.getIcon(side, 0);
        }
        return this.icons[((TileAlveary)tile).getIcon(side)];
    }

    @SideOnly(value=Side.CLIENT)
    private IIcon switchForSide(int textureId, int side) {
        if (side == 4 || side == 5) {
            if (textureId == 41) {
                return this.icons[3];
            }
            return this.icons[4];
        }
        if (textureId == 41) {
            return this.icons[4];
        }
        return this.icons[3];
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        super.onNeighborBlockChange(world, x, y, z, block);
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TileAlveary) {
            TileAlveary tileAlveary = (TileAlveary)tileEntity;
            ((MultiblockLogicAlveary)tileAlveary.getMultiblockLogic()).getController().reassemble();
        }
    }

    public ItemStack get(Type type, int amount) {
        return new ItemStack((Block)this, amount, type.ordinal());
    }

    public static enum Type {
        PLAIN,
        ENTRANCE,
        SWARMER,
        FAN,
        HEATER,
        HYGRO,
        STABILIZER,
        SIEVE;

        public static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

