/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.GuiHandlerBase;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.gui.IPagedInventory;
import forestry.core.inventory.ItemInventoryBackpack;
import forestry.core.network.GuiId;
import forestry.storage.gui.ContainerBackpack;
import forestry.storage.gui.ContainerNaturalistBackpack;
import forestry.storage.gui.GuiBackpack;
import forestry.storage.gui.GuiBackpackT2;
import forestry.storage.items.ItemBackpack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GuiHandlerStorage
extends GuiHandlerBase {
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandlerStorage.decodeGuiID(id);
        int guiData = GuiHandlerStorage.decodeGuiData(id);
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[cleanId]) {
            case ApiaristBackpackGUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
                PagedBackpackInventory inventory = new PagedBackpackInventory(player, 125, equipped, cleanId);
                return new GuiNaturalistInventory(speciesRoot, player, new ContainerNaturalistBackpack(player, inventory, guiData), inventory, guiData, 5);
            }
            case BackpackGUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new GuiBackpack(new ContainerBackpack(player, ContainerBackpack.Size.DEFAULT, equipped));
            }
            case BackpackT2GUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new GuiBackpackT2(new ContainerBackpack(player, ContainerBackpack.Size.T2, equipped));
            }
            case LepidopteristBackpackGUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");
                PagedBackpackInventory inventory = new PagedBackpackInventory(player, 125, equipped, id);
                return new GuiNaturalistInventory(speciesRoot, player, new ContainerNaturalistBackpack(player, inventory, guiData), inventory, guiData, 5);
            }
        }
        return null;
    }

    private static ItemStack getBackpackItem(EntityPlayer player) {
        ItemStack equipped = player.getCurrentEquippedItem();
        if (equipped == null) {
            return null;
        }
        if (equipped.getItem() instanceof ItemBackpack) {
            return equipped;
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandlerStorage.decodeGuiID(id);
        int guiData = GuiHandlerStorage.decodeGuiData(id);
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[cleanId]) {
            case ApiaristBackpackGUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new ContainerNaturalistBackpack(player, new PagedBackpackInventory(player, 125, equipped, cleanId), guiData);
            }
            case BackpackGUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new ContainerBackpack(player, ContainerBackpack.Size.DEFAULT, equipped);
            }
            case BackpackT2GUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new ContainerBackpack(player, ContainerBackpack.Size.T2, equipped);
            }
            case LepidopteristBackpackGUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new ContainerNaturalistBackpack(player, new PagedBackpackInventory(player, 125, equipped, cleanId), guiData);
            }
        }
        return null;
    }

    public static class PagedBackpackInventory
    extends ItemInventoryBackpack
    implements IPagedInventory {
        private final int guiId;

        public PagedBackpackInventory(EntityPlayer player, int size, ItemStack itemstack, int guiId) {
            super(player, size, itemstack);
            this.guiId = guiId;
        }

        @Override
        public void flipPage(EntityPlayer player, int page) {
            player.openGui(ForestryAPI.instance, GuiHandlerBase.encodeGuiData(this.guiId, page), player.worldObj, (int)player.posX, (int)player.posY, (int)player.posZ);
        }
    }
}

