/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.items;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.api.mail.ILetter;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.errors.EnumErrorCode;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.render.TextureManager;
import forestry.core.utils.SlotUtil;
import forestry.core.utils.StringUtil;
import forestry.mail.Letter;
import forestry.mail.items.ItemStamps;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemLetter
extends ItemInventoried {
    @SideOnly(value=Side.CLIENT)
    private IIcon[][] icons;

    public static ItemStack createStampedLetterStack(ILetter letter) {
        LetterSize size = ItemLetter.getSize(letter);
        int meta = ItemLetter.encodeMeta(LetterState.STAMPED, size);
        return ForestryItem.letters.getItemStack(1, meta);
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.isRemote) {
            if (itemstack.stackSize == 1) {
                entityplayer.openGui(ForestryAPI.instance, GuiId.LetterGUI.ordinal(), world, (int)entityplayer.posX, (int)entityplayer.posY, (int)entityplayer.posZ);
            } else {
                entityplayer.addChatMessage((IChatComponent)new ChatComponentTranslation("for.chat.mail.wrongstacksize", new Object[0]));
            }
        }
        return itemstack;
    }

    public boolean getShareTag() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new IIcon[3][4];
        for (int i = 0; i < 3; ++i) {
            this.icons[i][0] = TextureManager.registerTex(register, "mail/letter." + i + ".fresh");
            this.icons[i][1] = TextureManager.registerTex(register, "mail/letter." + i + ".stamped");
            this.icons[i][2] = TextureManager.registerTex(register, "mail/letter." + i + ".opened");
            this.icons[i][3] = TextureManager.registerTex(register, "mail/letter." + i + ".emptied");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        LetterState state = ItemLetter.getState(damage);
        LetterSize size = ItemLetter.getSize(damage);
        return this.icons[size.ordinal()][state.ordinal()];
    }

    private static int encodeMeta(LetterState state, LetterSize size) {
        int meta = size.ordinal() << 4;
        return meta |= state.ordinal();
    }

    private static LetterState getState(int meta) {
        int ordinal = meta & 0xF;
        LetterState[] values = LetterState.values();
        if (ordinal >= values.length) {
            ordinal = 0;
        }
        return values[ordinal];
    }

    private static LetterSize getSize(int meta) {
        int ordinal = meta >> 4;
        LetterSize[] values = LetterSize.values();
        if (ordinal >= values.length) {
            ordinal = 0;
        }
        return values[ordinal];
    }

    private static LetterSize getSize(ILetter letter) {
        int count = letter.countAttachments();
        if (count > 5) {
            return LetterSize.BIG;
        }
        if (count > 1) {
            return LetterSize.SMALL;
        }
        return LetterSize.EMPTY;
    }

    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        NBTTagCompound nbttagcompound = itemstack.getTagCompound();
        if (nbttagcompound == null) {
            list.add('<' + StringUtil.localize("gui.blank") + '>');
            return;
        }
        Letter letter = new Letter(nbttagcompound);
        letter.addTooltip(list);
    }

    public static class LetterInventory
    extends ItemInventory
    implements IErrorSource,
    IHintSource {
        private ILetter letter;

        public LetterInventory(EntityPlayer player, ItemStack itemstack) {
            super(player, 0, itemstack);
        }

        public ILetter getLetter() {
            return this.letter;
        }

        public void onContainerClosed() {
            ItemStack parent = this.getParent();
            if (parent == null) {
                return;
            }
            LetterState state = ItemLetter.getState(parent.getItemDamage());
            LetterSize size = ItemLetter.getSize(parent.getItemDamage());
            switch (state) {
                case OPENED: {
                    if (this.letter.countAttachments() > 0) break;
                    state = LetterState.EMPTIED;
                    break;
                }
                case FRESH: 
                case STAMPED: {
                    state = this.letter.isMailable() && this.letter.isPostPaid() ? LetterState.STAMPED : LetterState.FRESH;
                    size = ItemLetter.getSize(this.letter);
                    break;
                }
            }
            int meta = ItemLetter.encodeMeta(state, size);
            parent.setItemDamage(meta);
            this.letter.writeToNBT(parent.getTagCompound());
        }

        public void onLetterOpened() {
            int oldMeta;
            LetterState state;
            ItemStack parent = this.getParent();
            if (parent != null && ((state = ItemLetter.getState(oldMeta = parent.getItemDamage())) == LetterState.FRESH || state == LetterState.STAMPED)) {
                LetterSize size = ItemLetter.getSize(oldMeta);
                int newMeta = ItemLetter.encodeMeta(LetterState.OPENED, size);
                parent.setItemDamage(newMeta);
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            if (nbttagcompound == null) {
                return;
            }
            this.letter = new Letter(nbttagcompound);
        }

        @Override
        public ItemStack decrStackSize(int i, int j) {
            ItemStack result = this.letter.decrStackSize(i, j);
            this.letter.writeToNBT(this.getParent().getTagCompound());
            return result;
        }

        @Override
        public void setInventorySlotContents(int i, ItemStack itemstack) {
            this.letter.setInventorySlotContents(i, itemstack);
            this.letter.writeToNBT(this.getParent().getTagCompound());
        }

        @Override
        public ItemStack getStackInSlot(int i) {
            return this.letter.getStackInSlot(i);
        }

        @Override
        public int getSizeInventory() {
            return this.letter.getSizeInventory();
        }

        @Override
        public String getInventoryName() {
            return this.letter.getInventoryName();
        }

        @Override
        public int getInventoryStackLimit() {
            return this.letter.getInventoryStackLimit();
        }

        @Override
        public boolean isUseableByPlayer(EntityPlayer entityplayer) {
            return this.letter.isUseableByPlayer(entityplayer);
        }

        @Override
        public ItemStack getStackInSlotOnClosing(int slot) {
            return this.letter.getStackInSlotOnClosing(slot);
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (this.letter.isProcessed()) {
                return false;
            }
            if (SlotUtil.isSlotInRange(slotIndex, 18, 4)) {
                Item item = itemStack.getItem();
                return item instanceof ItemStamps;
            }
            if (SlotUtil.isSlotInRange(slotIndex, 0, 18)) {
                return !ForestryItem.letters.isItemEqual(itemStack);
            }
            return false;
        }

        @Override
        public ImmutableSet<IErrorState> getErrorStates() {
            ImmutableSet.Builder errorStates = ImmutableSet.builder();
            if (!this.letter.hasRecipient()) {
                errorStates.add((Object)EnumErrorCode.NORECIPIENT);
            }
            if (!this.letter.isProcessed() && !this.letter.isPostPaid()) {
                errorStates.add((Object)EnumErrorCode.NOTPOSTPAID);
            }
            return errorStates.build();
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("letter") != null && Config.hints.get("letter").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("letter");
        }
    }

    private static enum LetterSize {
        EMPTY,
        SMALL,
        BIG;

    }

    private static enum LetterState {
        FRESH,
        STAMPED,
        OPENED,
        EMPTIED;

    }
}

