/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.core.GuiHandlerBase;
import forestry.core.network.GuiId;
import forestry.mail.gui.ContainerCatalogue;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.gui.ContainerMailbox;
import forestry.mail.gui.ContainerPhilatelist;
import forestry.mail.gui.ContainerTradeName;
import forestry.mail.gui.ContainerTrader;
import forestry.mail.gui.GuiCatalogue;
import forestry.mail.gui.GuiLetter;
import forestry.mail.gui.GuiMailbox;
import forestry.mail.gui.GuiPhilatelist;
import forestry.mail.gui.GuiTradeName;
import forestry.mail.gui.GuiTrader;
import forestry.mail.items.ItemCatalogue;
import forestry.mail.items.ItemLetter;
import forestry.mail.tiles.TileMailbox;
import forestry.mail.tiles.TilePhilatelist;
import forestry.mail.tiles.TileTrader;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GuiHandlerMail
extends GuiHandlerBase {
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[id]) {
            case CatalogueGUI: {
                ItemStack cata = player.getCurrentEquippedItem();
                if (cata == null) {
                    return null;
                }
                if (cata.getItem() instanceof ItemCatalogue) {
                    return new GuiCatalogue(player);
                }
                return null;
            }
            case LetterGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                if (equipped.getItem() instanceof ItemLetter) {
                    return new GuiLetter(player, new ItemLetter.LetterInventory(player, equipped));
                }
                return null;
            }
            case MailboxGUI: {
                return new GuiMailbox(player.inventory, GuiHandlerMail.getTile(world, x, y, z, player, TileMailbox.class));
            }
            case PhilatelistGUI: {
                return new GuiPhilatelist(player.inventory, GuiHandlerMail.getTile(world, x, y, z, player, TilePhilatelist.class));
            }
            case TraderGUI: {
                return new GuiTrader(player.inventory, GuiHandlerMail.getTile(world, x, y, z, player, TileTrader.class));
            }
            case TraderNameGUI: {
                return new GuiTradeName(GuiHandlerMail.getTile(world, x, y, z, player, TileTrader.class));
            }
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[id]) {
            case CatalogueGUI: {
                ItemStack cata = player.getCurrentEquippedItem();
                if (cata == null) {
                    return null;
                }
                if (cata.getItem() instanceof ItemCatalogue) {
                    return new ContainerCatalogue(player);
                }
                return null;
            }
            case LetterGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                if (equipped.getItem() instanceof ItemLetter) {
                    return new ContainerLetter(player, new ItemLetter.LetterInventory(player, equipped));
                }
                return null;
            }
            case MailboxGUI: {
                return new ContainerMailbox(player.inventory, GuiHandlerMail.getTile(world, x, y, z, player, TileMailbox.class));
            }
            case PhilatelistGUI: {
                return new ContainerPhilatelist(player.inventory, GuiHandlerMail.getTile(world, x, y, z, player, TilePhilatelist.class));
            }
            case TraderGUI: {
                return new ContainerTrader(player.inventory, GuiHandlerMail.getTile(world, x, y, z, player, TileTrader.class));
            }
            case TraderNameGUI: {
                return new ContainerTradeName(GuiHandlerMail.getTile(world, x, y, z, player, TileTrader.class));
            }
        }
        return null;
    }
}

