/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableStacked
implements IFarmable {
    private final Block block;
    private final int matureHeight;
    private final int matureMeta;

    public FarmableStacked(Block block, int matureHeight, int matureMeta) {
        this.block = block;
        this.matureHeight = matureHeight;
        this.matureMeta = matureMeta;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        return world.getBlock(x, y, z) == this.block;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.getBlock(x, y + (this.matureHeight - 1), z) != this.block) {
            return null;
        }
        return new CropBlock(world, this.block, this.matureMeta, new Vect(x, y + (this.matureHeight - 1), z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStackUtil.equals(this.block, itemstack);
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return world.setBlock(x, y, z, this.block, 0, 2);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

