/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.genetics.IFruitBearer;
import forestry.core.network.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.Crop;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CropFruit
extends Crop {
    public CropFruit(World world, Vect position) {
        super(world, position);
    }

    @Override
    protected boolean isCrop(Vect pos) {
        TileEntity tile = this.world.getTileEntity(pos.x, pos.y, pos.z);
        if (!(tile instanceof IFruitBearer)) {
            return false;
        }
        IFruitBearer bearer = (IFruitBearer)tile;
        if (!bearer.hasFruit()) {
            return false;
        }
        return !(bearer.getRipeness() < 0.9f);
    }

    @Override
    protected Collection<ItemStack> harvestBlock(Vect pos) {
        TileEntity tile = this.world.getTileEntity(pos.x, pos.y, pos.z);
        if (!(tile instanceof IFruitBearer)) {
            return new ArrayList<ItemStack>();
        }
        Proxies.common.sendFXSignal(PacketFXSignal.VisualFXType.BLOCK_DESTROY, PacketFXSignal.SoundFXType.LEAF, this.world, pos.x, pos.y, pos.z, this.world.getBlock(pos.x, pos.y, pos.z), 0);
        return ((IFruitBearer)tile).pickFruit(null);
    }
}

