/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.blocks;

import com.google.common.collect.ImmutableList;
import forestry.core.blocks.BlockBase;
import forestry.core.tiles.TileEngine;
import forestry.core.tiles.TileUtil;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEngine
extends BlockBase {
    private static final EnumMap<ForgeDirection, List<AxisAlignedBB>> boundingBoxesForDirections = new EnumMap(ForgeDirection.class);

    public BlockEngine(Material material) {
        super(material, true);
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        TileEngine tile = TileUtil.getTile((IBlockAccess)world, x, y, z, TileEngine.class);
        if (tile == null) {
            super.addCollisionBoxesToList(world, x, y, z, mask, list, colliding);
            return;
        }
        ForgeDirection orientation = tile.getOrientation();
        List<AxisAlignedBB> boundingBoxes = boundingBoxesForDirections.get(orientation);
        if (boundingBoxes == null) {
            return;
        }
        for (AxisAlignedBB boundingBoxBase : boundingBoxes) {
            AxisAlignedBB boundingBox = boundingBoxBase.getOffsetBoundingBox((double)x, (double)y, (double)z);
            if (!mask.intersectsWith(boundingBox)) continue;
            list.add(boundingBox);
        }
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        TileEngine tile = TileUtil.getTile((IBlockAccess)world, x, y, z, TileEngine.class);
        if (tile == null) {
            return super.collisionRayTrace(world, x, y, z, origin, direction);
        }
        ForgeDirection orientation = tile.getOrientation();
        List<AxisAlignedBB> boundingBoxes = boundingBoxesForDirections.get(orientation);
        if (boundingBoxes == null) {
            return super.collisionRayTrace(world, x, y, z, origin, direction);
        }
        MovingObjectPosition nearestIntersection = null;
        for (AxisAlignedBB boundingBoxBase : boundingBoxes) {
            AxisAlignedBB boundingBox = boundingBoxBase.getOffsetBoundingBox((double)x, (double)y, (double)z);
            MovingObjectPosition intersection = boundingBox.calculateIntercept(origin, direction);
            if (intersection == null || nearestIntersection != null && !(intersection.hitVec.distanceTo(origin) < nearestIntersection.hitVec.distanceTo(origin))) continue;
            nearestIntersection = intersection;
        }
        if (nearestIntersection != null) {
            nearestIntersection.blockX = x;
            nearestIntersection.blockY = y;
            nearestIntersection.blockZ = z;
        }
        return nearestIntersection;
    }

    static {
        boundingBoxesForDirections.put(ForgeDirection.DOWN, (List<AxisAlignedBB>)ImmutableList.of((Object)AxisAlignedBB.getBoundingBox((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (Object)AxisAlignedBB.getBoundingBox((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75)));
        boundingBoxesForDirections.put(ForgeDirection.UP, (List<AxisAlignedBB>)ImmutableList.of((Object)AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), (Object)AxisAlignedBB.getBoundingBox((double)0.25, (double)0.5, (double)0.25, (double)0.75, (double)1.0, (double)0.75)));
        boundingBoxesForDirections.put(ForgeDirection.NORTH, (List<AxisAlignedBB>)ImmutableList.of((Object)AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), (Object)AxisAlignedBB.getBoundingBox((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.5)));
        boundingBoxesForDirections.put(ForgeDirection.SOUTH, (List<AxisAlignedBB>)ImmutableList.of((Object)AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), (Object)AxisAlignedBB.getBoundingBox((double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75, (double)1.0)));
        boundingBoxesForDirections.put(ForgeDirection.WEST, (List<AxisAlignedBB>)ImmutableList.of((Object)AxisAlignedBB.getBoundingBox((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (Object)AxisAlignedBB.getBoundingBox((double)0.0, (double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75)));
        boundingBoxesForDirections.put(ForgeDirection.EAST, (List<AxisAlignedBB>)ImmutableList.of((Object)AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), (Object)AxisAlignedBB.getBoundingBox((double)0.5, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75)));
    }
}

