/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.proxy.Proxies;
import java.util.IllegalFormatException;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class StringUtil {
    public static boolean canTranslate(String key) {
        return StatCollector.canTranslate((String)("for." + key));
    }

    public static boolean canTranslateTile(String key) {
        return StatCollector.canTranslate((String)("tile.for." + key));
    }

    public static String localize(String key) {
        return StatCollector.translateToLocal((String)("for." + key)).replace("\\n", "\n").replace("@", "%").replace("\\%", "@");
    }

    public static String localizeTile(String key) {
        return StatCollector.translateToLocal((String)("tile.for." + key)).replace("\\n", "\n").replace("@", "%").replace("\\%", "@");
    }

    public static String localizeAndFormat(String key, Object ... args) {
        return StringUtil.localizeAndFormatRaw("for." + key, args);
    }

    public static String localizeAndFormatRaw(String key, Object ... args) {
        String text = StatCollector.translateToLocal((String)key).replace("\\n", "\n").replace("@", "%").replace("\\%", "@");
        try {
            return String.format(text, args);
        }
        catch (IllegalFormatException ex) {
            return "Format error: " + text;
        }
    }

    public static String cleanTags(String tag) {
        return tag.replaceAll("[Ff]orestry\\p{Punct}", "").replaceAll("\\.[Ff]or\\p{Punct}", ".").replaceFirst("^tile\\.", "").replaceFirst("^item\\.", "");
    }

    public static String cleanItemName(ItemStack stack) {
        return StringUtil.cleanTags(stack.getUnlocalizedName());
    }

    public static String cleanItemName(Item item) {
        return StringUtil.cleanTags(item.getUnlocalizedName());
    }

    public static String cleanBlockName(Block block) {
        return StringUtil.cleanTags(block.getUnlocalizedName());
    }

    public static String append(String delim, String source, String appendix) {
        if (source.length() <= 0) {
            return appendix;
        }
        if (appendix.length() <= 0) {
            return source;
        }
        return source + delim + appendix;
    }

    public static String readableBoolean(boolean flag, String trueStr, String falseStr) {
        if (flag) {
            return trueStr;
        }
        return falseStr;
    }

    public static String floatAsPercent(float val) {
        return (int)(val * 100.0f) + " %";
    }

    public static String line(int length) {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            line.append('-');
        }
        return line.toString();
    }

    public static int getLineHeight(int maxWidth, String ... strings) {
        Minecraft minecraft = Proxies.common.getClientInstance();
        FontRenderer fontRenderer = minecraft.fontRenderer;
        int lineCount = 0;
        for (String string : strings) {
            lineCount += fontRenderer.listFormattedStringToWidth(string, maxWidth).size();
        }
        return lineCount * fontRenderer.FONT_HEIGHT;
    }
}

