/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;

public class PacketProgressBarUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private int windowId;
    private int dataId;
    private int value;

    public PacketProgressBarUpdate() {
    }

    public PacketProgressBarUpdate(int windowId, int dataId, int value) {
        super(PacketIdClient.GUI_PROGRESS_BAR);
        this.windowId = windowId;
        this.dataId = dataId;
        this.value = value;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeByte(this.windowId);
        data.writeByte(this.dataId);
        data.writeInt(this.value);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.windowId = data.readByte();
        this.dataId = data.readByte();
        this.value = data.readInt();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        if (player.openContainer != null && player.openContainer.windowId == this.windowId) {
            player.openContainer.updateProgressBar(this.dataId, this.value);
        }
    }
}

