/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.core.config.SessionVars;
import forestry.core.errors.FakeErrorSource;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.ledgers.ErrorLedger;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class LedgerManager {
    private final List<Ledger> ledgers = new ArrayList<Ledger>();
    private final List<ErrorLedger> errorLedgers = new ArrayList<ErrorLedger>();
    private IErrorSource errorSource;
    private final int maxWidth;
    public final GuiForestry gui;

    public LedgerManager(GuiForestry gui, int maxWidth) {
        this.gui = gui;
        this.errorSource = FakeErrorSource.instance;
        this.maxWidth = maxWidth;
    }

    public void add(IErrorSource errorSource) {
        if (errorSource == null) {
            return;
        }
        this.errorSource = errorSource;
        int maxErrorLedgerCount = (this.gui.getSizeY() - 10) / 24;
        for (int i = 0; i < maxErrorLedgerCount; ++i) {
            this.errorLedgers.add(new ErrorLedger(this));
        }
    }

    public void add(Ledger ledger) {
        this.ledgers.add(ledger);
        if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
            ledger.setFullyOpen();
        }
    }

    public void insert(Ledger ledger) {
        this.ledgers.add(this.ledgers.size() - 1, ledger);
    }

    private Ledger getAtPosition(int mX, int mY) {
        if (this.ledgers.size() > 0) {
            int xShift = (this.gui.width - this.gui.getSizeX()) / 2 + this.gui.getSizeX();
            int yShift = (this.gui.height - this.gui.getSizeY()) / 2 + 8;
            for (Ledger ledger : this.ledgers) {
                if (!ledger.isVisible()) continue;
                ledger.currentShiftX = xShift;
                ledger.currentShiftY = yShift;
                if (ledger.intersectsWith(mX, mY)) {
                    return ledger;
                }
                yShift += ledger.getHeight();
            }
        }
        int xShiftError = (this.gui.width - this.gui.getSizeX()) / 2;
        int yShiftError = (this.gui.height - this.gui.getSizeY()) / 2 + 8;
        for (ErrorLedger errorLedger : this.errorLedgers) {
            if (!errorLedger.isVisible()) continue;
            errorLedger.currentShiftX = xShiftError - errorLedger.getWidth();
            errorLedger.currentShiftY = yShiftError;
            if (errorLedger.intersectsWith(mX, mY)) {
                return errorLedger;
            }
            yShiftError += errorLedger.getHeight();
        }
        return null;
    }

    public void drawLedgers() {
        int yPos = 8;
        for (Ledger ledger : this.ledgers) {
            ledger.update();
            if (!ledger.isVisible()) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ledger.draw(this.gui.getSizeX(), yPos);
            yPos += ledger.getHeight();
        }
        ImmutableSet<IErrorState> errorStates = this.errorSource.getErrorStates();
        yPos = 8;
        int index = 0;
        for (IErrorState errorState : errorStates) {
            if (index >= this.errorLedgers.size()) break;
            ErrorLedger errorLedger = this.errorLedgers.get(index++);
            errorLedger.setState(errorState);
            errorLedger.update();
            if (!errorLedger.isVisible()) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            errorLedger.draw(-errorLedger.getWidth(), yPos);
            yPos += errorLedger.getHeight();
        }
    }

    public void drawTooltips(int mouseX, int mouseY) {
        Ledger ledger = this.getAtPosition(mouseX, mouseY);
        if (ledger != null) {
            int startX = mouseX - (this.gui.width - this.gui.getSizeX()) / 2 + 12;
            int startY = mouseY - (this.gui.height - this.gui.getSizeY()) / 2 - 12;
            String tooltip = ledger.getTooltip();
            Minecraft minecraft = Proxies.common.getClientInstance();
            int textWidth = minecraft.fontRenderer.getStringWidth(tooltip);
            this.gui.drawGradientRect(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
            minecraft.fontRenderer.drawStringWithShadow(tooltip, startX, startY, -1);
        }
    }

    public void handleMouseClicked(int x, int y, int mouseButton) {
        Ledger ledger;
        if (mouseButton == 0 && (ledger = this.getAtPosition(x, y)) != null && !ledger.handleMouseClicked(x, y, mouseButton)) {
            List<Ledger> toggleLedgers = this.ledgers.contains(ledger) ? this.ledgers : this.errorLedgers;
            for (Ledger other : toggleLedgers) {
                if (other == ledger || !other.isOpen()) continue;
                other.toggleOpen();
            }
            ledger.toggleOpen();
        }
    }

    public boolean ledgerOverlaps(int x, int y, int width, int height) {
        return this.getAtPosition(x + width, y + height) != null || this.getAtPosition(x + width, y) != null || this.getAtPosition(x, y + height) != null || this.getAtPosition(x, y) != null;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }
}

