/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.ContainerLiquidTanksHelper;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.tiles.ILiquidTankTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.IFluidTank;

public abstract class ContainerLiquidTanks<T extends TileEntity>
extends ContainerTile<T>
implements IContainerLiquidTanks {
    private final ContainerLiquidTanksHelper<T> helper;

    protected ContainerLiquidTanks(T tile, InventoryPlayer playerInventory, int xInv, int yInv) {
        super(tile, playerInventory, xInv, yInv);
        this.helper = new ContainerLiquidTanksHelper<T>(tile);
    }

    @Override
    public void handlePipetteClickClient(int slot, EntityPlayer player) {
        this.helper.handlePipetteClickClient(slot, player);
    }

    @Override
    public void handlePipetteClick(int slot, EntityPlayerMP player) {
        this.helper.handlePipetteClick(slot, player);
    }

    public void updateProgressBar(int messageId, int data) {
        super.updateProgressBar(messageId, data);
        ((ILiquidTankTile)this.tile).getTankManager().processGuiUpdate(messageId, data);
        ((ILiquidTankTile)this.tile).getGUINetworkData(messageId, data);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        ((ILiquidTankTile)this.tile).getTankManager().updateGuiData(this, this.crafters);
        for (Object crafter : this.crafters) {
            ((ILiquidTankTile)this.tile).sendGUINetworkData(this, (ICrafting)crafter);
        }
    }

    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        ((ILiquidTankTile)this.tile).getTankManager().initGuiData(this, icrafting);
    }

    @Override
    public IFluidTank getTank(int slot) {
        return ((ILiquidTankTile)this.tile).getTankManager().getTank(slot);
    }
}

