/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.core.EnumHumidity;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class MutationConditionHumidity
implements IMutationCondition {
    private final EnumHumidity minHumidity;
    private final EnumHumidity maxHumidity;

    public MutationConditionHumidity(EnumHumidity minHumidity, EnumHumidity maxHumidity) {
        this.minHumidity = minHumidity;
        this.maxHumidity = maxHumidity;
    }

    @Override
    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(x, z);
        EnumHumidity biomeHumidity = EnumHumidity.getFromValue(biome.rainfall);
        if (biomeHumidity.ordinal() < this.minHumidity.ordinal() || biomeHumidity.ordinal() > this.maxHumidity.ordinal()) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public String getDescription() {
        if (this.minHumidity != this.maxHumidity) {
            return String.format("Humidity between %s and %s.", new Object[]{this.minHumidity, this.maxHumidity});
        }
        return String.format("Humidity %s required.", new Object[]{this.minHumidity});
    }
}

