/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.CreativeTabForestry;
import forestry.core.blocks.IItemTyped;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.render.TextureManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSoil
extends Block
implements IItemTyped {
    private static final int degradeDelimiter = 3;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconHumus;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBogEarth;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconPeat;

    public BlockSoil() {
        super(Material.sand);
        this.setTickRandomly(true);
        this.setHardness(0.5f);
        this.setStepSound(soundTypeGrass);
        this.setCreativeTab(CreativeTabForestry.tabForestry);
    }

    public int tickRate(World world) {
        return 500;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        SoilType type = this.getTypeFromMeta(metadata);
        if (type == SoilType.PEAT) {
            ret.add(ForestryItem.peat.getItemStack());
            ret.add(new ItemStack(Blocks.dirt));
        } else if (type == SoilType.HUMUS) {
            ret.add(new ItemStack(Blocks.dirt));
        } else {
            ret.add(new ItemStack((Block)this, 1, SoilType.BOG_EARTH.ordinal()));
        }
        return ret;
    }

    public int getDamageValue(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) & 3;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.isRemote) {
            return;
        }
        int meta = world.getBlockMetadata(i, j, k);
        SoilType type = this.getTypeFromMeta(meta);
        if (type == SoilType.HUMUS) {
            BlockSoil.updateTickHumus(world, i, j, k);
        } else if (type == SoilType.BOG_EARTH) {
            BlockSoil.updateTickBogEarth(world, i, j, k);
        }
    }

    private static void updateTickHumus(World world, int i, int j, int k) {
        if (BlockSoil.isEnrooted(world, i, j, k)) {
            BlockSoil.degradeSoil(world, i, j, k);
        }
    }

    private static void updateTickBogEarth(World world, int i, int j, int k) {
        if (BlockSoil.isMoistened(world, i, j, k)) {
            BlockSoil.matureBog(world, i, j, k);
        }
    }

    private static boolean isEnrooted(World world, int x, int y, int z) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                Block block = world.getBlock(x + i, y + 1, z + j);
                if (block != Blocks.log && block != Blocks.sapling && block != ForestryBlock.saplingGE.block()) continue;
                return i != 0 || j != 0;
            }
        }
        return false;
    }

    private static void degradeSoil(World world, int x, int y, int z) {
        if (world.rand.nextInt(140) != 0) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        int type = meta & 3;
        int grade = meta >> 2;
        meta = ++grade << 2 | type;
        if (grade >= 3) {
            world.setBlock(x, y, z, (Block)Blocks.sand, 0, 2);
        } else {
            world.setBlockMetadataWithNotify(x, y, z, meta, 2);
        }
        world.markBlockForUpdate(x, y, z);
    }

    private static boolean isMoistened(World world, int x, int y, int z) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                Block block = world.getBlock(x + i, y, z + j);
                if (block != Blocks.water && block != Blocks.flowing_water) continue;
                return true;
            }
        }
        return false;
    }

    private static void matureBog(World world, int i, int j, int k) {
        if (world.rand.nextInt(13) != 0) {
            return;
        }
        int meta = world.getBlockMetadata(i, j, k);
        int type = meta & 3;
        int maturity = meta >> 2;
        if (maturity >= 3) {
            return;
        }
        meta = ++maturity << 2 | type;
        world.setBlockMetadataWithNotify(i, j, k, meta, 2);
        world.markBlockForUpdate(i, j, k);
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        EnumPlantType plantType = plant.getPlantType(world, x, y, z);
        if (plantType != EnumPlantType.Crop && plantType != EnumPlantType.Plains) {
            return false;
        }
        int meta = world.getBlockMetadata(x, y, z);
        SoilType type = this.getTypeFromMeta(meta);
        return type == SoilType.HUMUS;
    }

    protected boolean canSilkHarvest() {
        return false;
    }

    @Override
    public SoilType getTypeFromMeta(int meta) {
        int type = meta & 3;
        int maturity = meta >> 2;
        if (type == 1) {
            if (maturity < 3) {
                return SoilType.BOG_EARTH;
            }
            return SoilType.PEAT;
        }
        return SoilType.HUMUS;
    }

    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack((Block)this, 1, 0));
        itemList.add(new ItemStack((Block)this, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.iconHumus = TextureManager.registerTex(register, "soil/humus");
        this.iconBogEarth = TextureManager.registerTex(register, "soil/bog");
        this.iconPeat = TextureManager.registerTex(register, "soil/peat");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        SoilType type = this.getTypeFromMeta(meta);
        switch (type) {
            case HUMUS: {
                return this.iconHumus;
            }
            case BOG_EARTH: {
                return this.iconBogEarth;
            }
            case PEAT: {
                return this.iconPeat;
            }
        }
        return null;
    }

    public static enum SoilType {
        HUMUS,
        BOG_EARTH,
        PEAT;

    }
}

