/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.commands;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.core.commands.CommandHelpers;
import forestry.core.commands.SpeciesNotFoundException;
import forestry.core.commands.SubCommand;
import forestry.core.commands.TemplateNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class CommandBeeGive
extends SubCommand {
    private final String beeTypeHelpString;
    private final String[] beeTypeArr;

    public CommandBeeGive() {
        super("give");
        this.setPermLevel(SubCommand.PermLevel.ADMIN);
        ArrayList<String> beeTypeStrings = new ArrayList<String>();
        for (EnumBeeType type : EnumBeeType.values()) {
            if (type == EnumBeeType.NONE) continue;
            beeTypeStrings.add(type.getName());
        }
        this.beeTypeArr = beeTypeStrings.toArray(new String[beeTypeStrings.size()]);
        StringBuilder beeTypeHelp = new StringBuilder();
        String separator = ", ";
        Iterator iter = beeTypeStrings.iterator();
        while (iter.hasNext()) {
            beeTypeHelp.append((String)iter.next());
            if (!iter.hasNext()) continue;
            beeTypeHelp.append(separator);
        }
        this.beeTypeHelpString = beeTypeHelp.toString();
    }

    @Override
    public void processSubCommand(ICommandSender sender, String[] arguments) {
        if (arguments.length < 2) {
            this.printHelp(sender);
            return;
        }
        IBeeGenome beeGenome = CommandBeeGive.getBeeGenome(arguments[0]);
        EnumBeeType beeType = CommandBeeGive.getBeeType(arguments[1]);
        if (beeType == EnumBeeType.NONE) {
            this.printHelp(sender);
            return;
        }
        EntityPlayerMP player = arguments.length == 3 ? CommandHelpers.getPlayer(sender, arguments[2]) : CommandHelpers.getPlayer(sender, sender.getCommandSenderName());
        if (player == null) {
            this.printHelp(sender);
            return;
        }
        IBee bee = BeeManager.beeRoot.getBee(player.worldObj, beeGenome);
        if (beeType == EnumBeeType.QUEEN) {
            bee.mate(bee);
        }
        ItemStack beeStack = BeeManager.beeRoot.getMemberStack(bee, beeType.ordinal());
        player.dropPlayerItemWithRandomChoice(beeStack, true);
        CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.bee.give.given", player.getCommandSenderName(), bee.getGenome().getPrimary().getName(), beeType.getName());
    }

    private static IBeeGenome getBeeGenome(String speciesName) {
        IAllele species = null;
        for (String uid : AlleleManager.alleleRegistry.getRegisteredAlleles().keySet()) {
            if (!uid.equals(speciesName) || !(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleBeeSpecies)) continue;
            species = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(uid);
            break;
        }
        if (species == null) {
            for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(allele instanceof IAlleleBeeSpecies) || !allele.getName().equals(speciesName)) continue;
                species = (IAlleleBeeSpecies)allele;
                break;
            }
        }
        if (species == null) {
            throw new SpeciesNotFoundException(speciesName);
        }
        IAllele[] template = BeeManager.beeRoot.getTemplate(species.getUID());
        if (template == null) {
            throw new TemplateNotFoundException((IAlleleSpecies)species);
        }
        return BeeManager.beeRoot.templateAsGenome(template);
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] parameters) {
        if (parameters.length == 1) {
            List<String> tabCompletion = CommandHelpers.getListOfStringsMatchingLastWord(parameters, CommandBeeGive.getSpecies());
            tabCompletion.add("help");
            return tabCompletion;
        }
        if (parameters.length == 2) {
            return CommandHelpers.getListOfStringsMatchingLastWord(parameters, this.beeTypeArr);
        }
        if (parameters.length == 3) {
            return CommandHelpers.getListOfStringsMatchingLastWord(parameters, CommandHelpers.getPlayers());
        }
        return null;
    }

    private static String[] getSpecies() {
        ArrayList<String> species = new ArrayList<String>();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            species.add(allele.getName());
        }
        return species.toArray(new String[species.size()]);
    }

    private static EnumBeeType getBeeType(String beeTypeName) {
        for (EnumBeeType beeType : EnumBeeType.values()) {
            if (!beeType.getName().equalsIgnoreCase(beeTypeName)) continue;
            return beeType;
        }
        return EnumBeeType.NONE;
    }

    @Override
    public void printHelp(ICommandSender sender) {
        super.printHelp(sender);
        CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.beekeeping.give.available", this.beeTypeHelpString);
    }
}

