/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.EntityButterfly;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public abstract class AIButterflyBase
extends EntityAIBase {
    protected final EntityButterfly entity;

    protected AIButterflyBase(EntityButterfly entity) {
        this.entity = entity;
    }

    protected ChunkCoordinates getRandomDestination() {
        if (this.entity.isInWater()) {
            return this.getRandomDestinationUpwards();
        }
        Vec3 randomTarget = RandomPositionGenerator.findRandomTargetBlockAwayFrom((EntityCreature)this.entity, (int)16, (int)7, (Vec3)Vec3.createVectorHelper((double)this.entity.posX, (double)this.entity.posY, (double)this.entity.posZ));
        if (randomTarget == null) {
            return null;
        }
        ChunkCoordinates dest = new ChunkCoordinates((int)randomTarget.xCoord, (int)randomTarget.yCoord, (int)randomTarget.zCoord);
        if (this.validateDestination(dest, false)) {
            return dest;
        }
        return null;
    }

    protected ChunkCoordinates getRandomDestinationUpwards() {
        ChunkCoordinates dest = new ChunkCoordinates((int)this.entity.posX, (int)this.entity.posY + this.entity.getRNG().nextInt(10) + 2, (int)this.entity.posZ);
        if (this.validateDestination(dest, true)) {
            return dest;
        }
        return null;
    }

    private boolean validateDestination(ChunkCoordinates dest, boolean allowFluids) {
        if (dest.posY < 1) {
            return false;
        }
        Block block = this.entity.worldObj.getBlock(dest.posX, dest.posY, dest.posZ);
        if (!allowFluids && block.getMaterial().isLiquid()) {
            return false;
        }
        if (!block.getBlocksMovement((IBlockAccess)this.entity.worldObj, dest.posX, dest.posY, dest.posZ)) {
            return false;
        }
        return this.entity.getButterfly().isAcceptedEnvironment(this.entity.worldObj, dest.posX, dest.posY, dest.posZ);
    }
}

