/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.core.blocks.BlockSoil;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.logic.CropPeat;
import forestry.farming.logic.FarmLogicWatered;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class FarmLogicPeat
extends FarmLogicWatered {
    public FarmLogicPeat(IFarmHousing housing) {
        super(housing, ForestryBlock.soil.getItemStack(1, 1), ForestryBlock.soil.getItemStack(1, 1));
    }

    @Override
    public boolean isAcceptedGround(ItemStack itemStack) {
        if (super.isAcceptedGround(itemStack)) {
            return true;
        }
        Block block = BlockSoil.getBlockFromItem((Item)itemStack.getItem());
        if (block == null || !(block instanceof BlockSoil)) {
            return false;
        }
        BlockSoil blockSoil = (BlockSoil)block;
        BlockSoil.SoilType soilType = blockSoil.getTypeFromMeta(itemStack.getItemDamage());
        return soilType == BlockSoil.SoilType.BOG_EARTH || soilType == BlockSoil.SoilType.PEAT;
    }

    @Override
    public int getFertilizerConsumption() {
        return 2;
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Peat Bog";
        }
        return "Managed Peat Bog";
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, FarmDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockSoil blockSoil;
            BlockSoil.SoilType soilType;
            Block block;
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            ItemStack occupant = VectUtil.getAsItemStack(world, position);
            if (occupant.getItem() == null || (block = Block.getBlockFromItem((Item)occupant.getItem())) == null || !(block instanceof BlockSoil) || (soilType = (blockSoil = (BlockSoil)block).getTypeFromMeta(occupant.getItemDamage())) != BlockSoil.SoilType.PEAT) continue;
            crops.push(new CropPeat(world, position));
        }
        return crops;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return ForestryItem.peat.item().getIconFromDamage(0);
    }
}

