/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.core.recipes.nei.NEIUtils;
import forestry.core.recipes.nei.PositionedFluidTank;
import forestry.core.recipes.nei.RecipeHandlerBase;
import forestry.factory.gui.GuiBottler;
import forestry.factory.tiles.TileBottler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class NEIHandlerBottler
extends RecipeHandlerBase {
    private static final List<TileBottler.BottlerRecipe> recipes = new ArrayList<TileBottler.BottlerRecipe>();

    @Override
    public void prepare() {
        for (FluidContainerRegistry.FluidContainerData container : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            TileBottler.BottlerRecipe recipe = TileBottler.RecipeManager.findMatchingRecipe(container.fluid, container.emptyContainer);
            if (recipe == null) continue;
            recipes.add(recipe);
        }
    }

    @Override
    public String getRecipeID() {
        return "forestry.bottler";
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.for.factory.0.name");
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/bottler.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(75, 27, 24, 17);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBottler.class;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)43, (int)0, (int)48, (int)11, (int)123, (int)65);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(75, 27, 176, 74, 24, 17, 40, 0);
    }

    @Override
    public void loadAllRecipes() {
        for (TileBottler.BottlerRecipe recipe : recipes) {
            this.arecipes.add(new CachedBottlerRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (TileBottler.BottlerRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.bottled, (ItemStack)result)) continue;
            this.arecipes.add(new CachedBottlerRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        for (TileBottler.BottlerRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.can, (ItemStack)ingred)) continue;
            this.arecipes.add(new CachedBottlerRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingred) {
        for (TileBottler.BottlerRecipe recipe : recipes) {
            if (!NEIUtils.areFluidsSameType(recipe.input, ingred)) continue;
            this.arecipes.add(new CachedBottlerRecipe(recipe));
        }
    }

    public class CachedBottlerRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedFluidTank fluid;
        public PositionedStack input;
        public PositionedStack output;

        public CachedBottlerRecipe(TileBottler.BottlerRecipe recipe) {
            if (recipe.input != null) {
                this.fluid = new PositionedFluidTank(recipe.input, 10000, new Rectangle(48, 6, 16, 58), NEIHandlerBottler.this.getGuiTexture(), new Point(176, 0));
            }
            if (recipe.can != null) {
                this.input = new PositionedStack((Object)recipe.can, 111, 8);
            }
            if (recipe.bottled != null) {
                this.output = new PositionedStack((Object)recipe.bottled, 111, 44);
            }
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.fluid;
        }
    }
}

