/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.core.GuiHandlerBase;
import forestry.core.network.GuiId;
import forestry.core.network.PacketSocketUpdate;
import forestry.core.proxy.Proxies;
import forestry.energy.gui.ContainerEngineBronze;
import forestry.energy.gui.ContainerEngineCopper;
import forestry.energy.gui.ContainerEngineTin;
import forestry.energy.gui.ContainerGenerator;
import forestry.energy.gui.GuiEngineBronze;
import forestry.energy.gui.GuiEngineCopper;
import forestry.energy.gui.GuiEngineTin;
import forestry.energy.gui.GuiGenerator;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.energy.tiles.TileEngineElectric;
import forestry.energy.tiles.TileEnginePeat;
import forestry.energy.tiles.TileGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class GuiHandlerEnergy
extends GuiHandlerBase {
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[id]) {
            case EngineBiogasGUI: {
                return new GuiEngineBronze(player.inventory, GuiHandlerEnergy.getTile(world, x, y, z, player, TileEngineBiogas.class));
            }
            case EnginePeatGUI: {
                return new GuiEngineCopper(player.inventory, GuiHandlerEnergy.getTile(world, x, y, z, player, TileEnginePeat.class));
            }
            case EngineElectricGUI: {
                return new GuiEngineTin(player.inventory, GuiHandlerEnergy.getTile(world, x, y, z, player, TileEngineElectric.class));
            }
            case GeneratorGUI: {
                return new GuiGenerator(player.inventory, GuiHandlerEnergy.getTile(world, x, y, z, player, TileGenerator.class));
            }
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[id]) {
            case EngineBiogasGUI: {
                return new ContainerEngineBronze(player.inventory, GuiHandlerEnergy.getTile(world, x, y, z, player, TileEngineBiogas.class));
            }
            case EnginePeatGUI: {
                return new ContainerEngineCopper(player.inventory, GuiHandlerEnergy.getTile(world, x, y, z, player, TileEnginePeat.class));
            }
            case EngineElectricGUI: {
                TileEngineElectric tile = GuiHandlerEnergy.getTile(world, x, y, z, player, TileEngineElectric.class);
                Proxies.net.sendToPlayer(new PacketSocketUpdate(tile), player);
                return new ContainerEngineTin(player.inventory, tile);
            }
            case GeneratorGUI: {
                return new ContainerGenerator(player.inventory, GuiHandlerEnergy.getTile(world, x, y, z, player, TileGenerator.class));
            }
        }
        return null;
    }
}

