/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

public enum EnumTankLevel {
    EMPTY(0),
    LOW(25),
    MEDIUM(50),
    HIGH(75),
    MAXIMUM(100);

    private final int level;

    private EnumTankLevel(int level) {
        this.level = level;
    }

    public int getLevelScaled(int scale) {
        return this.level * scale / 100;
    }

    public static EnumTankLevel rateTankLevel(int scaled) {
        if (scaled < 5) {
            return EMPTY;
        }
        if (scaled < 30) {
            return LOW;
        }
        if (scaled < 60) {
            return MEDIUM;
        }
        if (scaled < 90) {
            return HIGH;
        }
        return MAXIMUM;
    }
}

