/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.INBTTagable;
import forestry.api.core.IToolPipette;
import forestry.core.items.ItemForestry;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public class ItemPipette
extends ItemForestry
implements IToolPipette {
    @SideOnly(value=Side.CLIENT)
    private IIcon primaryIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon secondaryIcon;

    public ItemPipette() {
        this.setMaxStackSize(1);
        this.setFull3D();
    }

    public boolean getShareTag() {
        return true;
    }

    @Override
    public boolean canPipette(ItemStack itemstack) {
        PipetteContents contained = new PipetteContents(itemstack.getTagCompound());
        return !contained.isFull();
    }

    @Override
    public int fill(ItemStack itemstack, FluidStack liquid, boolean doFill) {
        int filled;
        PipetteContents contained = new PipetteContents(itemstack.getTagCompound());
        int limit = this.getCapacity(itemstack);
        if (contained.contents == null) {
            filled = liquid.amount > limit ? limit : liquid.amount;
            contained.contents = new FluidStack(liquid, filled);
            filled = liquid.amount;
        } else {
            if (contained.contents.amount >= limit) {
                return 0;
            }
            if (!contained.contents.isFluidEqual(liquid)) {
                return 0;
            }
            int space = limit - contained.contents.amount;
            filled = liquid.amount > space ? space : liquid.amount;
            contained.contents.amount += filled;
        }
        if (doFill) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            contained.writeToNBT(nbttagcompound);
            itemstack.setTagCompound(nbttagcompound);
            itemstack.setItemDamage(1);
        }
        return filled;
    }

    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        PipetteContents contained = new PipetteContents(itemstack.getTagCompound());
        contained.addTooltip(list);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.primaryIcon = TextureManager.registerTex(register, StringUtil.cleanItemName(this) + ".0");
        this.secondaryIcon = TextureManager.registerTex(register, StringUtil.cleanItemName(this) + ".1");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        if (damage <= 0) {
            return this.primaryIcon;
        }
        return this.secondaryIcon;
    }

    @Override
    public FluidStack drain(ItemStack pipette, int maxDrain, boolean doDrain) {
        PipetteContents contained = new PipetteContents(pipette.getTagCompound());
        if (contained.contents == null || contained.contents.getFluid().getID() <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (contained.contents.amount < drained) {
            drained = contained.contents.amount;
        }
        if (doDrain) {
            contained.contents.amount -= drained;
            if (contained.contents.amount <= 0) {
                pipette.setTagCompound(null);
                pipette.setItemDamage(0);
            } else {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                contained.writeToNBT(nbttagcompound);
                pipette.setTagCompound(nbttagcompound);
            }
        }
        return new FluidStack(contained.contents, drained);
    }

    @Override
    public int getCapacity(ItemStack pipette) {
        return 1000;
    }

    static class PipetteContents
    implements INBTTagable {
        FluidStack contents;

        public PipetteContents(NBTTagCompound nbttagcompound) {
            if (nbttagcompound != null) {
                this.readFromNBT(nbttagcompound);
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            this.contents = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound);
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            if (this.contents != null) {
                this.contents.writeToNBT(nbttagcompound);
            }
        }

        public boolean isFull() {
            if (this.contents == null) {
                return false;
            }
            return this.contents.getFluid().getID() > 0 && this.contents.amount >= 1000;
        }

        public void addTooltip(List<String> list) {
            if (this.contents == null) {
                return;
            }
            String descr = this.contents.getFluid().getLocalizedName(this.contents);
            descr = descr + " (" + this.contents.amount + " mb)";
            list.add(descr);
        }
    }
}

