/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import cpw.mods.fml.common.FMLCommonHandler;
import forestry.factory.tiles.ICrafterWorktable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;

public class SlotCrafter
extends SlotCrafting {
    private final IInventory craftMatrix;
    private final ICrafterWorktable crafter;

    public SlotCrafter(EntityPlayer player, IInventory craftMatrix, ICrafterWorktable crafter, int slot, int xPos, int yPos) {
        super(player, craftMatrix, craftMatrix, slot, xPos, yPos);
        this.craftMatrix = craftMatrix;
        this.crafter = crafter;
    }

    public ItemStack decrStackSize(int amount) {
        if (!this.getHasStack()) {
            return null;
        }
        return this.getStack();
    }

    public boolean canTakeStack(EntityPlayer player) {
        return this.crafter.canTakeStack(this.getSlotIndex());
    }

    public ItemStack getStack() {
        return this.crafter.getResult();
    }

    public boolean getHasStack() {
        return this.getStack() != null && this.crafter.canTakeStack(this.getSlotIndex());
    }

    public void onPickupFromSlot(EntityPlayer player, ItemStack itemStack) {
        if (!this.crafter.onCraftingStart(player)) {
            return;
        }
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, itemStack, this.craftMatrix);
        this.onCrafting(itemStack);
        this.crafter.onCraftingComplete(player);
    }
}

