/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.tiles.IRestrictedAccessTile;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.StringUtil;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;

public class OwnerLedger
extends Ledger {
    private final IAccessHandler accessHandler;

    public OwnerLedger(LedgerManager manager, IRestrictedAccessTile tile) {
        super(manager, "owner");
        this.accessHandler = tile.getAccessHandler();
        Minecraft minecraft = Proxies.common.getClientInstance();
        boolean playerIsOwner = this.accessHandler.isOwner((EntityPlayer)minecraft.thePlayer);
        this.maxHeight = playerIsOwner ? 60 : 36;
    }

    private boolean isAccessButton(int mouseX, int mouseY) {
        int shiftX = this.currentShiftX;
        int shiftY = this.currentShiftY + 44;
        return mouseX >= shiftX && (float)mouseX <= (float)this.currentShiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + 12;
    }

    @Override
    public boolean isVisible() {
        return this.accessHandler.isOwned();
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        EnumAccess accessType = this.accessHandler.getAccessType();
        IIcon accessIcon = TextureManager.getInstance().getDefault("misc/access." + accessType.toString().toLowerCase(Locale.ENGLISH));
        this.drawIcon(accessIcon, x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(StringUtil.localize("gui.owner"), x + 22, y + 8);
        this.drawText(PlayerUtil.getOwnerName(this.accessHandler), x + 22, y + 20);
        Minecraft minecraft = Proxies.common.getClientInstance();
        boolean playerIsOwner = this.accessHandler.isOwner((EntityPlayer)minecraft.thePlayer);
        if (playerIsOwner) {
            this.drawSubheader(StringUtil.localize("gui.access") + ':', x + 22, y + 32);
            this.drawIcon(accessIcon, x + 20, y + 40);
            this.drawText(StringUtil.localize(accessType.getName()), x + 38, y + 44);
        }
    }

    @Override
    public String getTooltip() {
        return StringUtil.localize("gui.owner") + ": " + PlayerUtil.getOwnerName(this.accessHandler);
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (this.isAccessButton(x, y)) {
            Minecraft minecraft = Proxies.common.getClientInstance();
            EntityClientPlayerMP player = minecraft.thePlayer;
            return this.accessHandler.switchAccessRule((EntityPlayer)player);
        }
        return false;
    }
}

