/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.buttons;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.gui.buttons.IButtonTextureSet;
import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBetterButton
extends GuiButton
implements IToolTipProvider {
    private static final ResourceLocation TEXTURE = new ResourceLocation("forestry", "textures/gui/buttons.png");
    protected IButtonTextureSet texture;
    private ToolTip toolTip;
    private boolean useTexWidth = false;

    public GuiBetterButton(int id, int x, int y, IButtonTextureSet texture) {
        super(id, x, y, texture.getWidth(), texture.getHeight(), "");
        this.texture = texture;
        this.useTexWidth = true;
    }

    public GuiBetterButton setTexture(IButtonTextureSet texture) {
        this.texture = texture;
        this.width = texture.getWidth();
        this.height = texture.getHeight();
        return this;
    }

    public GuiBetterButton setUseTextureWidth() {
        this.useTexWidth = true;
        return this;
    }

    public GuiBetterButton setWidth(int width) {
        this.width = width;
        this.useTexWidth = false;
        return this;
    }

    public GuiBetterButton setLabel(String label) {
        this.displayString = label;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.texture.getHeight();
    }

    public int getTextColor(boolean mouseOver) {
        if (!this.enabled) {
            return -6250336;
        }
        if (mouseOver) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    public boolean isMouseOverButton(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.getWidth() && mouseY < this.yPosition + this.getHeight();
    }

    protected static void bindButtonTextures(Minecraft minecraft) {
        minecraft.renderEngine.bindTexture(TEXTURE);
    }

    public void drawButton(Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        FontRenderer fontrenderer = minecraft.fontRenderer;
        GuiBetterButton.bindButtonTextures(minecraft);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = this.texture.getX();
        int yOffset = this.texture.getY();
        int h = this.texture.getHeight();
        int w = this.texture.getWidth();
        boolean mouseOver = this.isMouseOverButton(mouseX, mouseY);
        int hoverState = this.getHoverState(mouseOver);
        if (this.useTexWidth) {
            this.drawTexturedModalRect(this.xPosition, this.yPosition, xOffset, yOffset + hoverState * h, w, h);
        } else {
            this.drawTexturedModalRect(this.xPosition, this.yPosition, xOffset, yOffset + hoverState * h, this.width / 2, h);
            this.drawTexturedModalRect(this.xPosition + this.width / 2, this.yPosition, xOffset + w - this.width / 2, yOffset + hoverState * h, this.width / 2, h);
        }
        this.mouseDragged(minecraft, mouseX, mouseY);
        this.drawCenteredString(fontrenderer, this.displayString, this.xPosition + this.getWidth() / 2, this.yPosition + (h - 8) / 2, this.getTextColor(mouseOver));
    }

    @Override
    public ToolTip getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(ToolTip tips) {
        this.toolTip = tips;
    }

    @Override
    public boolean isToolTipVisible() {
        return this.visible;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.isMouseOverButton(mouseX, mouseY);
    }
}

